/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.cache.Cache;
import com.impetus.kundera.cache.CacheProvider;
import com.impetus.kundera.entity.PersonnelDTO;
import com.impetus.kundera.persistence.EntityManagerSession;
import junit.framework.TestCase;

public class EntityManagerSessionTest
extends TestCase {
    EntityManagerSession ems;
    CacheProvider cacheProvider;
    Cache cache;
    String cacheResource = "/ehcache-test.xml";
    String cacheProviderClassName = "com.impetus.kundera.cache.ehcache.EhCacheProvider";
    PersonnelDTO person1;
    PersonnelDTO person2;

    protected void setUp() throws Exception {
        super.setUp();
        Class<?> cacheProviderClass = Class.forName(this.cacheProviderClassName);
        this.cacheProvider = (CacheProvider)cacheProviderClass.newInstance();
        this.cacheProvider.init(this.cacheResource);
        this.cache = (Cache)this.cacheProvider.createCache("Kundera");
        this.ems = new EntityManagerSession(this.cache);
        this.person1 = new PersonnelDTO("1", "Amresh", "Singh");
        this.person2 = new PersonnelDTO("2", "Vivek", "Mishra");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.ems.clear();
        this.cacheProvider.shutdown();
        this.cache = null;
    }

    public void test() {
        EntityManagerSessionTest.assertNotNull((Object)this.ems);
        this.ems.store((Object)this.person1.getPersonId(), (Object)this.person1);
        EntityManagerSessionTest.assertEquals((int)1, (int)this.ems.getL2Cache().size());
        this.ems.store((Object)this.person2.getPersonId(), (Object)this.person2);
        EntityManagerSessionTest.assertEquals((int)2, (int)this.ems.getL2Cache().size());
        PersonnelDTO p1 = (PersonnelDTO)this.ems.lookup(PersonnelDTO.class, (Object)this.person1.getPersonId());
        EntityManagerSessionTest.assertNotNull((Object)p1);
        EntityManagerSessionTest.assertEquals((String)this.person1.getPersonId(), (String)p1.getPersonId());
        EntityManagerSessionTest.assertEquals((String)this.person1.getFirstName(), (String)p1.getFirstName());
        EntityManagerSessionTest.assertEquals((String)this.person1.getLastName(), (String)p1.getLastName());
        this.ems.remove(PersonnelDTO.class, (Object)this.person1.getPersonId());
        EntityManagerSessionTest.assertNotNull((Object)this.ems);
        EntityManagerSessionTest.assertEquals((int)1, (int)this.ems.getL2Cache().size());
        this.ems.clear();
        EntityManagerSessionTest.assertNotNull((Object)this.ems);
        EntityManagerSessionTest.assertEquals((int)0, (int)this.ems.getL2Cache().size());
    }
}

