/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.cache.ehcache;

import com.impetus.kundera.cache.Cache;
import com.impetus.kundera.entity.EhCacheEntity;
import com.impetus.kundera.graph.Node;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.query.Person;
import java.lang.reflect.Field;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class EhcacheTest {
    private static final String PU = "ehacheTest";
    private EntityManagerFactory emf;
    private EntityManager em;
    protected Map propertyMap = null;

    @Before
    public void setUp() throws Exception {
        this.emf = Persistence.createEntityManagerFactory((String)PU, (Map)this.propertyMap);
        this.em = this.emf.createEntityManager();
    }

    @Test
    public void testDummy() {
    }

    public void testEhCache() {
        EhCacheEntity entity1 = this.prepareData("1", 32);
        this.em.persist((Object)entity1);
        EhCacheEntity entity2 = this.prepareData("2", 32);
        this.em.persist((Object)entity2);
        Cache l2Cache = (Cache)this.em.getEntityManagerFactory().getCache();
        PersistenceDelegator persistenceDelegator = null;
        persistenceDelegator = this.getPersistenceDelegator(persistenceDelegator);
        Node node1 = persistenceDelegator.getPersistenceCache().getMainCache().getNodeFromCache((Object)entity1, KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)persistenceDelegator.getKunderaMetadata(), entity1.getClass()), persistenceDelegator);
        EhCacheEntity foundNode1 = (EhCacheEntity)l2Cache.get((Object)node1.getNodeId());
        Assert.assertNotNull((Object)foundNode1);
        Assert.assertEquals((Object)foundNode1, (Object)node1.getData());
        this.em.remove((Object)entity1);
        Node node2 = persistenceDelegator.getPersistenceCache().getMainCache().getNodeFromCache((Object)entity2, KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)persistenceDelegator.getKunderaMetadata(), entity1.getClass()), persistenceDelegator);
        Assert.assertNotNull((Object)l2Cache.get((Object)node2.getNodeId()));
        EhCacheEntity foundNode2 = (EhCacheEntity)l2Cache.get((Object)node2.getNodeId());
        Assert.assertEquals((Object)foundNode2, (Object)node2.getData());
        Assert.assertNull((Object)l2Cache.get((Object)node1.getNodeId()));
        entity1.setAge(99);
        this.em.persist((Object)entity1);
        this.em.flush();
        node1 = persistenceDelegator.getPersistenceCache().getMainCache().getNodeFromCache((Object)entity1, KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)persistenceDelegator.getKunderaMetadata(), entity1.getClass()), persistenceDelegator);
        foundNode1 = (EhCacheEntity)l2Cache.get((Object)node1.getNodeId());
        Assert.assertNotNull((Object)foundNode1);
        Assert.assertEquals((Object)foundNode1, (Object)node1.getData());
        Assert.assertEquals((Object)foundNode1.getAge(), (Object)new Integer(99));
        Assert.assertEquals((Object)foundNode1.getAge(), (Object)entity1.getAge());
        this.em.clear();
        Assert.assertNull((Object)l2Cache.get((Object)node2.getNodeId()));
    }

    private PersistenceDelegator getPersistenceDelegator(PersistenceDelegator persistenceDelegator) {
        try {
            Field pd = this.em.getClass().getDeclaredField("persistenceDelegator");
            if (!pd.isAccessible()) {
                pd.setAccessible(true);
            }
            persistenceDelegator = (PersistenceDelegator)pd.get(this.em);
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)"Invalid configuration");
        }
        catch (SecurityException e) {
            Assert.fail((String)"Invalid configuration");
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Invalid configuration");
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)"Invalid configuration");
        }
        return persistenceDelegator;
    }

    private EhCacheEntity prepareData(String rowKey, int age) {
        EhCacheEntity o = new EhCacheEntity();
        o.setPersonId(rowKey);
        o.setPersonName("vivek");
        o.setAge(age);
        o.setDay(Person.Day.THURSDAY);
        return o;
    }
}

