/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.cache.ehcache;

import com.impetus.kundera.cache.CacheException;
import com.impetus.kundera.cache.CacheProvider;
import com.impetus.kundera.cache.ehcache.EhCacheWrapper;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.util.ClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheProvider
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(EhCacheProvider.class);
    private CacheManager manager;
    private javax.persistence.Cache cache;
    private static final String NET_SF_EHCACHE_CONFIGURATION_RESOURCE_NAME = "net.sf.ehcache.configurationResourceName";
    private boolean initializing;
    private List<CacheEventListener> listeners = new ArrayList<CacheEventListener>();

    public void init(String cacheResourceName) {
        if (this.manager != null) {
            log.warn("Attempt to restart an already started CacheFactory. Using previously created EhCacheFactory.");
            return;
        }
        this.initializing = true;
        try {
            String configurationResourceName = cacheResourceName;
            if (configurationResourceName == null || configurationResourceName.length() == 0) {
                this.manager = CacheManager.create();
            } else {
                if (!configurationResourceName.startsWith("/")) {
                    configurationResourceName = "/" + configurationResourceName;
                    log.info("prepending / to " + configurationResourceName + ". It should be placed in the root" + "of the classpath rather than in a package.");
                }
                URL url = this.loadResource(configurationResourceName);
                this.manager = CacheManager.create((URL)url);
            }
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e.getMessage().startsWith("Cannot parseConfiguration CacheManager. Attempt to create a new instance of CacheManager using the diskStorePath")) {
                throw new CacheException("Could not init EhCacheFactory.", (Throwable)e);
            }
            throw e;
        }
        finally {
            this.initializing = false;
        }
    }

    public synchronized void init(Map<?, ?> properties) {
        if (this.manager != null) {
            log.warn("Attempt to restart an already started CacheFactory. Using previously created EhCacheFactory.");
            return;
        }
        this.initializing = true;
        try {
            String configurationResourceName = null;
            if (properties != null) {
                configurationResourceName = (String)properties.get(NET_SF_EHCACHE_CONFIGURATION_RESOURCE_NAME);
            }
            if (configurationResourceName == null || configurationResourceName.length() == 0) {
                this.manager = CacheManager.create();
            } else {
                if (!configurationResourceName.startsWith("/")) {
                    configurationResourceName = "/" + configurationResourceName;
                    log.info("prepending / to " + configurationResourceName + ". It should be placed in the root" + "of the classpath rather than in a package.");
                }
                URL url = this.loadResource(configurationResourceName);
                this.manager = CacheManager.create((URL)url);
            }
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e.getMessage().startsWith("Cannot parseConfiguration CacheManager. Attempt to create a new instance of CacheManager using the diskStorePath")) {
                throw new CacheException("Could not init EhCacheFactory.", (Throwable)e);
            }
            throw new CacheException((Throwable)e);
        }
        finally {
            this.initializing = false;
        }
    }

    private URL loadResource(String configurationResourceName) {
        ClassLoader standardClassloader = ClassLoaderUtil.getStandardClassLoader();
        URL url = null;
        if (standardClassloader != null) {
            url = standardClassloader.getResource(configurationResourceName);
        }
        if (url == null) {
            url = this.getClass().getResource(configurationResourceName);
        }
        log.info("Creating EhCacheFactory from a specified resource: " + configurationResourceName + " Resolved to URL: " + url);
        if (url == null) {
            log.warn("A configurationResourceName was set to {} but the resource could not be loaded from the classpath.Ehcache will configure itself using defaults.", (Object)configurationResourceName);
        }
        return url;
    }

    public javax.persistence.Cache createCache(String name) {
        if (this.manager == null) {
            throw new CacheException("CacheFactory was not initialized. Call init() before creating a cache.");
        }
        try {
            Cache backingCache;
            Cache cache = this.manager.getCache(name);
            if (cache == null) {
                log.warn("Could not find a specific ehcache configuration for cache named [" + name + "]; using defaults.");
                this.manager.addCache(name);
                cache = this.manager.getCache(name);
            }
            if (!(backingCache = cache).getCacheEventNotificationService().hasCacheEventListeners() && this.listeners.size() > 0) {
                for (CacheEventListener listener : this.listeners) {
                    if (backingCache.getCacheEventNotificationService().getCacheEventListeners().contains(listener)) continue;
                    backingCache.getCacheEventNotificationService().registerListener(listener);
                }
            }
            this.cache = new EhCacheWrapper(cache);
            return this.cache;
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException("Could not create cache: " + name, (Throwable)e);
        }
    }

    public javax.persistence.Cache getCache(String cacheName) throws CacheException {
        if (this.cache == null) {
            this.cache = this.createCache(cacheName);
        }
        return this.cache;
    }

    public void shutdown() {
        if (this.manager != null) {
            this.manager.removalAll();
            this.manager = null;
        }
        this.cache = null;
    }

    public void clearAll() {
        this.manager.clearAll();
    }

    public CacheManager getCacheManager() {
        return this.manager;
    }

    public void addDefaultListener(CacheEventListener cacheEventListener) {
        this.listeners.add(cacheEventListener);
    }
}

