/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.index;

import com.impetus.kundera.cache.ElementCollectionCacheManager;
import com.impetus.kundera.index.DocumentIndexer;
import com.impetus.kundera.index.LuceneIndexingException;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.query.KunderaQuery;
import com.impetus.kundera.utils.KunderaCoreUtils;
import com.impetus.kundera.utils.ReflectUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.RAMDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexer
extends DocumentIndexer {
    private static Logger log = LoggerFactory.getLogger(LuceneIndexer.class);
    private static IndexWriter w;
    private static IndexReader reader;
    private static Directory index;
    private static boolean isInitialized;
    private static LuceneIndexer indexer;
    private static boolean readyForCommit;
    private static String luceneDirPath;

    private LuceneIndexer(String lucDirPath) {
        try {
            luceneDirPath = lucDirPath;
            File file = new File(luceneDirPath);
            if (file.exists()) {
                FSDirectory sourceDir = FSDirectory.open((Path)this.getIndexDirectory().toPath());
                index = new RAMDirectory(sourceDir, IOContext.DEFAULT);
            } else {
                index = new RAMDirectory();
            }
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
            LogDocMergePolicy logDocMergePolicy = new LogDocMergePolicy();
            logDocMergePolicy.setMergeFactor(1000);
            indexWriterConfig.setMergePolicy((MergePolicy)logDocMergePolicy);
            w = new IndexWriter(index, indexWriterConfig);
            w.getConfig().setRAMBufferSizeMB(32.0);
        }
        catch (Exception e) {
            log.error("Error while instantiating LuceneIndexer, Caused by :.", (Throwable)e);
            throw new LuceneIndexingException((Throwable)e);
        }
    }

    public static synchronized LuceneIndexer getInstance(String lucDirPath) {
        if (indexer == null && lucDirPath != null) {
            indexer = new LuceneIndexer(lucDirPath);
        }
        return indexer;
    }

    private IndexWriter getIndexWriter() {
        return w;
    }

    private IndexReader getIndexReader() {
        if (reader == null) {
            try {
                if (!isInitialized) {
                    FSDirectory sourceDir = FSDirectory.open((Path)this.getIndexDirectory().toPath());
                    this.copy((Directory)sourceDir, index);
                    isInitialized = true;
                }
                reader = DirectoryReader.open((Directory)index);
            }
            catch (IndexNotFoundException infex) {
                log.warn("No index found in given directory, caused by:", (Object)infex.getMessage());
            }
            catch (Exception e) {
                log.error("Error while instantiating LuceneIndexer, Caused by :.", (Throwable)e);
                throw new LuceneIndexingException((Throwable)e);
            }
        }
        return reader;
    }

    private File getIndexDirectory() {
        File file = new File(luceneDirPath);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        return file;
    }

    public final void index(EntityMetadata metadata, MetamodelImpl metaModel, Object object) {
        this.indexDocument(metadata, metaModel, object, null, null);
        this.onCommit();
    }

    public final void unindex(EntityMetadata metadata, Object id, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, Class<?> parentClazz) throws LuceneIndexingException {
        if (log.isDebugEnabled()) {
            log.debug("Unindexing @Entity[{}] for key:{}", (Object)metadata.getEntityClazz().getName(), id);
        }
        String luceneQuery = null;
        boolean isEmbeddedId = false;
        MetamodelImpl metaModel = null;
        if (kunderaMetadata != null && metadata != null) {
            metaModel = (MetamodelImpl)kunderaMetadata.getApplicationMetadata().getMetamodel(metadata.getPersistenceUnit());
            isEmbeddedId = metaModel.isEmbeddable(metadata.getIdAttribute().getBindableJavaType());
        }
        try {
            QueryParser qp = new QueryParser("6077004083174677888.default_property", (Analyzer)new StandardAnalyzer());
            qp.setLowercaseExpandedTerms(false);
            qp.setAllowLeadingWildcard(true);
            luceneQuery = this.getLuceneQuery(metadata, id, isEmbeddedId, metaModel, parentClazz);
            Query q = qp.parse(luceneQuery);
            w.deleteDocuments(new Query[]{q});
            w.commit();
            w.close();
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
            LogDocMergePolicy logDocMergePolicy = new LogDocMergePolicy();
            logDocMergePolicy.setMergeFactor(1000);
            indexWriterConfig.setMergePolicy((MergePolicy)logDocMergePolicy);
            w = new IndexWriter(index, indexWriterConfig);
            w.getConfig().setRAMBufferSizeMB(32.0);
        }
        catch (Exception e) {
            log.error("Error while instantiating LuceneIndexer, Caused by :.", (Throwable)e);
            throw new LuceneIndexingException((Throwable)e);
        }
    }

    private String getLuceneQuery(EntityMetadata metadata, Object id, boolean isEmbeddedId, MetamodelImpl metaModel, Class<?> parentClazz) {
        StringBuilder luceneQuery = new StringBuilder("+").append("entity.class").append(":").append(QueryParser.escape((String)metadata.getEntityClazz().getCanonicalName().toLowerCase())).append(" AND +");
        if (isEmbeddedId) {
            id = KunderaCoreUtils.prepareCompositeKey((SingularAttribute)metadata.getIdAttribute(), (MetamodelImpl)metaModel, (Object)id);
            luceneQuery.append("6077004083174677888.entity.id").append(":").append(QueryParser.escape((String)id.toString()));
        } else {
            luceneQuery.append(this.getCannonicalPropertyName(QueryParser.escape((String)metadata.getEntityClazz().getSimpleName()), QueryParser.escape((String)((AbstractAttribute)metadata.getIdAttribute()).getJPAColumnName()))).append(":").append(QueryParser.escape((String)id.toString()));
        }
        if (parentClazz != null) {
            luceneQuery.append(" AND +").append("6077004083174677888.parent.class").append(":").append(parentClazz.getCanonicalName().toLowerCase());
        }
        return luceneQuery.toString();
    }

    public final void update(EntityMetadata metadata, MetamodelImpl metaModel, Object entity, Object id, String parentId) {
        if (log.isDebugEnabled()) {
            log.debug("Updating @Entity[{}] for key:{}", (Object)metadata.getEntityClazz().getName(), id);
        }
        this.updateDocument(metadata, metaModel, entity, parentId, entity.getClass(), true);
    }

    public void prepareEmbeddedId(TopDocs docs, Map<String, Object> indexCol, IndexSearcher searcher, EntityMetadata metadata, MetamodelImpl metaModel) {
        try {
            for (ScoreDoc sc : docs.scoreDocs) {
                Document doc = searcher.doc(sc.doc);
                HashMap<String, Object> embeddedIdFields = new HashMap<String, Object>();
                EmbeddableType embeddableId = metaModel.embeddable(metadata.getIdAttribute().getBindableJavaType());
                Set embeddedAttributes = embeddableId.getAttributes();
                this.prepareEmbeddedIdFields(embeddedAttributes, metaModel, embeddedIdFields, doc, metadata);
                String entityId = doc.get("6077004083174677888.entity.id");
                indexCol.put(entityId, embeddedIdFields);
            }
        }
        catch (Exception e) {
            log.error("Error while parsing Lucene Query {} ", (Throwable)e);
            throw new LuceneIndexingException((Throwable)e);
        }
    }

    private void prepareEmbeddedIdFields(Set<Attribute> embeddedAttributes, MetamodelImpl metaModel, Map<String, Object> embeddedIdFields, Document doc, EntityMetadata metadata) {
        for (Attribute attribute : embeddedAttributes) {
            if (ReflectUtils.isTransientOrStatic((Field)((Field)attribute.getJavaMember()))) continue;
            if (metaModel.isEmbeddable(attribute.getJavaType())) {
                EmbeddableType embeddable = metaModel.embeddable(attribute.getJavaType());
                this.prepareEmbeddedIdFields(embeddable.getAttributes(), metaModel, embeddedIdFields, doc, metadata);
                continue;
            }
            String columnName = ((AbstractAttribute)attribute).getJPAColumnName();
            embeddedIdFields.put(columnName, doc.get(metadata.getEntityClazz().getSimpleName() + "." + columnName));
        }
    }

    public final Map<String, Object> search(String luceneQuery, int start, int count, boolean fetchRelation, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, EntityMetadata metadata) {
        boolean isEmbeddedId = false;
        MetamodelImpl metaModel = null;
        if (kunderaMetadata != null && metadata != null) {
            metaModel = (MetamodelImpl)kunderaMetadata.getApplicationMetadata().getMetamodel(metadata.getPersistenceUnit());
            isEmbeddedId = metaModel.isEmbeddable(metadata.getIdAttribute().getBindableJavaType());
        }
        reader = this.getIndexReader();
        if (-1 == count) {
            count = 100;
        }
        if (log.isDebugEnabled()) {
            log.debug("Searching index with query[{}], start:{} , count:" + count, (Object)luceneQuery, (Object)start);
        }
        HashMap<String, Object> indexCol = new HashMap<String, Object>();
        if (reader == null) {
            return indexCol;
        }
        QueryParser qp = null;
        IndexSearcher searcher = new IndexSearcher(reader);
        qp = new QueryParser("6077004083174677888.default_property", (Analyzer)new StandardAnalyzer());
        try {
            qp.setAllowLeadingWildcard(true);
            Query q = qp.parse(luceneQuery);
            TopDocs docs = searcher.search(q, count);
            int nullCount = 0;
            if (isEmbeddedId) {
                this.prepareEmbeddedId(docs, indexCol, searcher, metadata, metaModel);
            } else {
                for (ScoreDoc sc : docs.scoreDocs) {
                    Document doc = searcher.doc(sc.doc);
                    String entityId = doc.get(fetchRelation ? "6077004083174677888.parent.id" : "6077004083174677888.entity.id");
                    String superCol = doc.get("6077004083174677888.entity.super.indexname");
                    if (superCol == null) {
                        superCol = "SuperCol" + nullCount++;
                    }
                    indexCol.put(superCol + "|" + entityId, entityId);
                }
            }
        }
        catch (Exception e) {
            log.error("Error while parsing Lucene Query {} ", (Object)luceneQuery, (Object)e);
            throw new LuceneIndexingException((Throwable)e);
        }
        reader = null;
        return indexCol;
    }

    @Override
    public void indexDocument(EntityMetadata metadata, Document document) {
        if (log.isDebugEnabled()) {
            log.debug("Indexing document: {} for in file system using Lucene", (Object)document);
        }
        IndexWriter w = this.getIndexWriter();
        try {
            w.addDocument((Iterable)document);
        }
        catch (Exception e) {
            log.error("Error while indexing document {} into Lucene, Caused by:{} ", (Object)document, (Object)e);
            throw new LuceneIndexingException("Error while indexing document " + document + " into Lucene.", (Throwable)e);
        }
    }

    public void updateDocument(String id, Document document, String EmbeddedEntityFieldName) {
        if (log.isDebugEnabled()) {
            log.debug("Updateing indexed document: {} for in file system using Lucene", (Object)document);
        }
        IndexWriter w = this.getIndexWriter();
        try {
            Term term = null;
            term = EmbeddedEntityFieldName == null ? new Term("6077004083174677888.entity.id", id) : new Term(EmbeddedEntityFieldName, id);
            w.updateDocument(term, (Iterable)document);
        }
        catch (LuceneIndexingException lie) {
            log.error("Error while updating LuceneIndexer, Caused by :.", (Throwable)lie);
            throw new LuceneIndexingException((Throwable)lie);
        }
        catch (IOException ioe) {
            log.error("Error while reading Lucene indexes, Caused by :.", (Throwable)ioe);
        }
    }

    private void flushInternal() {
        try {
            if (w != null && readyForCommit) {
                w.commit();
                this.copy(index, (Directory)FSDirectory.open((Path)this.getIndexDirectory().toPath()));
                readyForCommit = false;
                reader = null;
                isInitialized = false;
            }
        }
        catch (Exception e) {
            log.error("Error while Flushing Lucene Indexes, Caused by: ", (Throwable)e);
            throw new LuceneIndexingException("Error while Flushing Lucene Indexes", (Throwable)e);
        }
    }

    public void close() {
        try {
            if (w != null && readyForCommit) {
                w.commit();
                this.copy(index, (Directory)FSDirectory.open((Path)this.getIndexDirectory().toPath()));
            }
        }
        catch (Exception e) {
            log.error("Error while closing lucene indexes, Caused by: ", (Throwable)e);
            throw new LuceneIndexingException("Error while closing lucene indexes.", (Throwable)e);
        }
    }

    public void flush() {
    }

    public void index(EntityMetadata metadata, MetamodelImpl metaModel, Object object, String parentId, Class<?> clazz) {
        this.indexDocument(metadata, metaModel, object, parentId, clazz);
        this.onCommit();
    }

    public boolean entityExistsInIndex(Class<?> entityClass, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, EntityMetadata metadata) {
        Map<String, Object> results;
        String luceneQuery = "+entity.class:" + entityClass.getCanonicalName().toLowerCase();
        try {
            results = this.search(luceneQuery, 0, 10, false, kunderaMetadata, metadata);
        }
        catch (LuceneIndexingException e) {
            return false;
        }
        return results != null && !results.isEmpty();
    }

    public boolean documentExistsInIndex(EntityMetadata metadata, Object id, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, boolean isEmbeddedId, Class<?> parentClazz) {
        Map<String, Object> results;
        String luceneQuery = null;
        MetamodelImpl metaModel = (MetamodelImpl)kunderaMetadata.getApplicationMetadata().getMetamodel(metadata.getPersistenceUnit());
        luceneQuery = this.getLuceneQuery(metadata, id, isEmbeddedId, metaModel, parentClazz);
        try {
            results = this.search(luceneQuery, 0, 10, false, kunderaMetadata, metadata);
        }
        catch (LuceneIndexingException e) {
            results = null;
        }
        return results != null && !results.isEmpty();
    }

    private Document indexDocument(EntityMetadata metadata, MetamodelImpl metaModel, Object object, String parentId, Class<?> clazz) {
        if (log.isDebugEnabled()) {
            log.debug("Indexing @Entity[{}],{} ", (Object)metadata.getEntityClazz().getName(), object);
        }
        Document currentDoc = this.updateOrCreateIndex(metadata, metaModel, object, parentId, clazz, false);
        return currentDoc;
    }

    private Document updateOrCreateIndex(EntityMetadata metadata, MetamodelImpl metaModel, Object entity, String parentId, Class<?> clazz, boolean isUpdate) {
        boolean isEmbeddedId = metaModel.isEmbeddable(metadata.getIdAttribute().getBindableJavaType());
        if (!metadata.isIndexable()) {
            return null;
        }
        Document document = null;
        Object embeddedObject = null;
        Object rowKey = null;
        try {
            rowKey = PropertyAccessorHelper.getId((Object)entity, (EntityMetadata)metadata);
        }
        catch (PropertyAccessException e1) {
            throw new LuceneIndexingException("Can't access Primary key property from " + metadata.getEntityClazz(), (Throwable)e1);
        }
        if (metadata.getType().equals((Object)EntityMetadata.Type.SUPER_COLUMN_FAMILY)) {
            Map embeddables = metaModel.getEmbeddables(metadata.getEntityClazz());
            for (String attributeName : embeddables.keySet()) {
                EmbeddableType embeddableAttribute = (EmbeddableType)embeddables.get(attributeName);
                EntityType entityType = metaModel.entity(metadata.getEntityClazz());
                embeddedObject = PropertyAccessorHelper.getObject((Object)entity, (Field)((Field)entityType.getAttribute(attributeName).getJavaMember()));
                if (embeddedObject == null) continue;
                if (embeddedObject instanceof Collection) {
                    document = this.updateOrCreateIndexCollectionTypeEmbeddedObject(metadata, metaModel, entity, parentId, clazz, isUpdate, document, embeddedObject, rowKey, attributeName, embeddableAttribute);
                    continue;
                }
                document = this.prepareDocumentForSuperColumn(metadata, entity, attributeName, parentId, clazz);
                this.createSuperColumnDocument(metadata, entity, document, metaModel.isEmbeddable(embeddedObject.getClass()) ? embeddedObject : entity, embeddableAttribute, metaModel);
                if (isUpdate) {
                    this.updateDocument(parentId, document, null);
                    continue;
                }
                this.indexDocument(metadata, document);
            }
        } else {
            document = this.updateOrCreateIndexNonSuperColumnFamily(metadata, metaModel, entity, parentId, clazz, isUpdate, isEmbeddedId, rowKey);
        }
        return document;
    }

    private Document updateOrCreateIndexNonSuperColumnFamily(EntityMetadata metadata, MetamodelImpl metaModel, Object entity, String parentId, Class<?> clazz, boolean isUpdate, boolean isEmbeddedId, Object rowKey) {
        Document document = new Document();
        this.addEntityClassToDocument(metadata, entity, document, metaModel);
        this.addEntityFieldsToDocument(metadata, entity, document, metaModel);
        this.addAssociatedEntitiesToDocument(metadata, entity, document, metaModel);
        this.addParentKeyToDocument(parentId, document, clazz);
        if (isUpdate) {
            if (isEmbeddedId) {
                String compositeId = KunderaCoreUtils.prepareCompositeKey((SingularAttribute)metadata.getIdAttribute(), (MetamodelImpl)metaModel, (Object)rowKey);
                this.updateDocument(compositeId, document, null);
                EmbeddableType embeddableId = metaModel.embeddable(metadata.getIdAttribute().getBindableJavaType());
                Set embeddedAttributes = embeddableId.getAttributes();
                this.updateOrCreateIndexEmbeddedIdFields(embeddedAttributes, metaModel, document, metadata, rowKey);
            } else {
                this.updateDocument(rowKey.toString(), document, null);
            }
        } else {
            this.indexDocument(metadata, document);
        }
        return document;
    }

    private void updateOrCreateIndexEmbeddedIdFields(Set<Attribute> embeddedAttributes, MetamodelImpl metaModel, Document document, EntityMetadata metadata, Object rowKey) {
        try {
            for (Attribute attribute : embeddedAttributes) {
                if (ReflectUtils.isTransientOrStatic((Field)((Field)attribute.getJavaMember()))) continue;
                if (metaModel.isEmbeddable(attribute.getJavaType())) {
                    EmbeddableType embeddable = metaModel.embeddable(attribute.getJavaType());
                    this.updateOrCreateIndexEmbeddedIdFields(embeddable.getAttributes(), metaModel, document, metadata, ((Field)attribute.getJavaMember()).get(rowKey));
                    continue;
                }
                String columnName = ((AbstractAttribute)attribute).getJPAColumnName();
                Object embeddedColumn = PropertyAccessorHelper.getObject((Object)rowKey, (Field)((Field)attribute.getJavaMember()));
                this.updateDocument(embeddedColumn.toString(), document, columnName);
            }
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage());
        }
    }

    private Document updateOrCreateIndexCollectionTypeEmbeddedObject(EntityMetadata metadata, MetamodelImpl metaModel, Object entity, String parentId, Class<?> clazz, boolean isUpdate, Document document, Object embeddedObject, Object rowKey, String attributeName, EmbeddableType embeddableAttribute) {
        ElementCollectionCacheManager ecCacheHandler = ElementCollectionCacheManager.getInstance();
        if (ecCacheHandler.isCacheEmpty()) {
            int count = 0;
            for (Object obj : (Collection)embeddedObject) {
                String elementCollectionObjectName = attributeName + "#" + count;
                document = this.prepareDocumentForSuperColumn(metadata, entity, elementCollectionObjectName, parentId, clazz);
                this.createSuperColumnDocument(metadata, entity, document, obj, embeddableAttribute, metaModel);
                if (isUpdate) {
                    this.updateDocument(parentId, document, null);
                } else {
                    this.indexDocument(metadata, document);
                }
                ++count;
            }
        } else {
            int lastEmbeddedObjectCount = ecCacheHandler.getLastElementCollectionObjectCount(rowKey);
            for (Object obj : (Collection)embeddedObject) {
                document = this.indexCollectionObject(metadata, entity, parentId, clazz, isUpdate, rowKey, attributeName, embeddableAttribute, ecCacheHandler, lastEmbeddedObjectCount, obj, metaModel);
            }
        }
        return document;
    }

    private Document indexCollectionObject(EntityMetadata metadata, Object entity, String parentId, Class<?> clazz, boolean isUpdate, Object rowKey, String attributeName, EmbeddableType embeddableAttribute, ElementCollectionCacheManager ecCacheHandler, int lastEmbeddedObjectCount, Object obj, MetamodelImpl metamodel) {
        String elementCollectionObjectName = ecCacheHandler.getElementCollectionObjectName(rowKey, obj);
        if (elementCollectionObjectName == null) {
            elementCollectionObjectName = attributeName + "#" + ++lastEmbeddedObjectCount;
        }
        Document currentDoc = this.prepareDocumentForSuperColumn(metadata, entity, elementCollectionObjectName, parentId, clazz);
        this.createSuperColumnDocument(metadata, entity, currentDoc, obj, embeddableAttribute, metamodel);
        if (isUpdate) {
            this.updateDocument(parentId, currentDoc, null);
        } else {
            this.indexDocument(metadata, currentDoc);
        }
        return currentDoc;
    }

    private void onCommit() {
        isInitialized = true;
        readyForCommit = true;
        this.flushInternal();
    }

    public void index(Class entityClazz, EntityMetadata entityMetadata, Map<String, Object> values, Object parentId, Class parentClazz) {
        throw new UnsupportedOperationException("Method not supported");
    }

    public void unIndex(Class entityClazz, Object entity, EntityMetadata metadata, MetamodelImpl metamodel) {
        throw new UnsupportedOperationException("Method not supported");
    }

    public Map<String, Object> search(Class<?> clazz, EntityMetadata m, String luceneQuery, int start, int end) {
        throw new UnsupportedOperationException("Method not supported");
    }

    private void copy(Directory src, Directory to) throws IOException {
        for (String file : src.listAll()) {
            src.copyFrom(src, file, to.toString(), IOContext.DEFAULT);
        }
    }

    private void updateDocument(EntityMetadata metadata, MetamodelImpl metaModel, Object entity, String parentId, Class<? extends Object> class1, boolean b) {
        this.updateOrCreateIndex(metadata, metaModel, entity, parentId, entity.getClass(), true);
        this.onCommit();
    }

    public Map<String, Object> search(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, KunderaQuery kunderaQuery, PersistenceDelegator persistenceDelegator, EntityMetadata m, int maxResults) {
        return null;
    }
}

