/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.polyglot.tests;

import com.impetus.kundera.polyglot.entities.AddressB1M;
import com.impetus.kundera.polyglot.entities.PersonB1M;
import com.impetus.kundera.polyglot.tests.PersonAddressTestBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OMBPolyglotTest
extends PersonAddressTestBase {
    @Before
    public void setUp() throws Exception {
        super.init();
    }

    @Test
    public void testCRUD() {
        this.executeAllTests();
    }

    @Override
    protected void insert() {
        PersonB1M personnel = new PersonB1M();
        personnel.setPersonId("bionetomany_1");
        personnel.setPersonName("Amresh");
        HashSet<AddressB1M> addresses = new HashSet<AddressB1M>();
        AddressB1M address1 = new AddressB1M();
        address1.setAddressId("bionetomany_a");
        address1.setStreet("AAAAAAAAAAAAA");
        AddressB1M address2 = new AddressB1M();
        address2.setAddressId("bionetomany_b");
        address2.setStreet("BBBBBBBBBBB");
        addresses.add(address1);
        addresses.add(address2);
        personnel.setAddresses(addresses);
        this.dao.insert((Object)personnel);
    }

    @Override
    protected void find() {
        PersonB1M p = (PersonB1M)this.dao.findPerson(PersonB1M.class, (Object)"bionetomany_1");
        this.assertPerson(p);
    }

    @Override
    protected void findPersonByIdColumn() {
        PersonB1M p = (PersonB1M)this.dao.findPersonByIdColumn(PersonB1M.class, (Object)"bionetomany_1");
        this.assertPerson(p);
    }

    @Override
    protected void findPersonByName() {
        List persons = this.dao.findPersonByName(PersonB1M.class, "Amresh");
        Assert.assertNotNull((Object)persons);
        Assert.assertFalse((boolean)persons.isEmpty());
        Assert.assertTrue((persons.size() == 1 ? 1 : 0) != 0);
        PersonB1M person = (PersonB1M)persons.get(0);
        this.assertPerson(person);
    }

    @Override
    protected void findAddressByIdColumn() {
    }

    @Override
    protected void findAddressByStreet() {
    }

    @Override
    protected void update() {
        PersonB1M p = (PersonB1M)this.dao.findPerson(PersonB1M.class, (Object)"bionetomany_1");
        this.assertPerson(p);
        p.setPersonName("Saurabh");
        for (AddressB1M address : p.getAddresses()) {
            address.setStreet("Brand New Street");
        }
        this.dao.merge((Object)p);
        PersonB1M pAfterMerge = (PersonB1M)this.dao.findPerson(PersonB1M.class, (Object)"bionetomany_1");
        this.assertPersonAfterUpdate(pAfterMerge);
    }

    @Override
    protected void remove() {
        PersonB1M p = (PersonB1M)this.dao.findPerson(PersonB1M.class, (Object)"bionetomany_1");
        this.assertPersonAfterUpdate(p);
        this.dao.remove((Object)"bionetomany_1", PersonB1M.class);
        PersonB1M pAfterRemoval = (PersonB1M)this.dao.findPerson(PersonB1M.class, (Object)"bionetomany_1");
        Assert.assertNull((Object)pAfterRemoval);
    }

    private void assertPerson(PersonB1M p) {
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((String)"bionetomany_1", (String)p.getPersonId());
        Assert.assertEquals((String)"Amresh", (String)p.getPersonName());
        Set adds = p.getAddresses();
        Assert.assertNotNull((Object)adds);
        Assert.assertFalse((boolean)adds.isEmpty());
        Assert.assertEquals((int)2, (int)adds.size());
        for (AddressB1M address : adds) {
            Assert.assertNotNull((Object)address);
            PersonB1M personB1M = address.getPerson();
        }
    }

    private void assertPersonAfterUpdate(PersonB1M p) {
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((String)"bionetomany_1", (String)p.getPersonId());
        Assert.assertEquals((String)"Saurabh", (String)p.getPersonName());
        Set adds = p.getAddresses();
        Assert.assertNotNull((Object)adds);
        Assert.assertFalse((boolean)adds.isEmpty());
        Assert.assertEquals((int)2, (int)adds.size());
        for (AddressB1M address : adds) {
            Assert.assertNotNull((Object)address);
            Assert.assertEquals((String)"Brand New Street", (String)address.getStreet());
            PersonB1M personB1M = address.getPerson();
        }
    }

    @After
    public void tearDown() throws Exception {
        super.close();
    }
}

