/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.polyglot.tests;

import com.impetus.kundera.polyglot.entities.AddressB11FK;
import com.impetus.kundera.polyglot.entities.PersonB11FK;
import com.impetus.kundera.polyglot.tests.PersonAddressTestBase;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OOBPolyglotTest
extends PersonAddressTestBase {
    @Before
    public void setUp() throws Exception {
        super.init();
    }

    @Test
    public void testCRUD() {
        this.executeAllTests();
    }

    @Override
    protected void insert() {
        PersonB11FK person = new PersonB11FK();
        person.setPersonId("bionetoonefk_1");
        person.setPersonName("Amresh");
        AddressB11FK address = new AddressB11FK();
        address.setAddressId("bionetoonefk_a");
        address.setStreet("123, New street");
        person.setAddress(address);
        address.setPerson(person);
        this.dao.insert((Object)person);
    }

    @Override
    protected void find() {
        PersonB11FK p = (PersonB11FK)this.dao.findPerson(PersonB11FK.class, (Object)"bionetoonefk_1");
        this.assertPersonnel(p);
    }

    @Override
    protected void findPersonByIdColumn() {
        PersonB11FK p = (PersonB11FK)this.dao.findPersonByIdColumn(PersonB11FK.class, (Object)"bionetoonefk_1");
        this.assertPersonnel(p);
    }

    @Override
    protected void findPersonByName() {
        List persons = this.dao.findPersonByName(PersonB11FK.class, "Amresh");
        Assert.assertNotNull((Object)persons);
        Assert.assertFalse((boolean)persons.isEmpty());
        Assert.assertTrue((persons.size() == 1 ? 1 : 0) != 0);
        this.assertPersonnel((PersonB11FK)persons.get(0));
    }

    @Override
    protected void findAddressByIdColumn() {
    }

    @Override
    protected void findAddressByStreet() {
    }

    @Override
    protected void update() {
        try {
            PersonB11FK p = (PersonB11FK)this.dao.findPerson(PersonB11FK.class, (Object)"bionetoonefk_1");
            this.assertPersonnel(p);
            this.dao.merge((Object)p);
            p = (PersonB11FK)this.dao.findPerson(PersonB11FK.class, (Object)"bionetoonefk_1");
            this.assertPersonnel(p);
            p.setPersonName("Saurabh");
            p.getAddress().setStreet("Brand New Street");
            this.dao.merge((Object)p);
            PersonB11FK pAfterMerge = (PersonB11FK)this.dao.findPerson(PersonB11FK.class, (Object)"bionetoonefk_1");
            this.assertPersonnelAfterUpdate(pAfterMerge);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Override
    protected void remove() {
        PersonB11FK p = (PersonB11FK)this.dao.findPerson(PersonB11FK.class, (Object)"bionetoonefk_1");
        this.assertPersonnelAfterUpdate(p);
        this.dao.remove((Object)"bionetoonefk_1", PersonB11FK.class);
        PersonB11FK pAfterRemoval = (PersonB11FK)this.dao.findPerson(PersonB11FK.class, (Object)"bionetoonefk_1");
        Assert.assertNull((Object)pAfterRemoval);
    }

    private void assertPersonnel(PersonB11FK p) {
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((String)"bionetoonefk_1", (String)p.getPersonId());
        Assert.assertEquals((String)"Amresh", (String)p.getPersonName());
        AddressB11FK address = p.getAddress();
        this.assertAddress(address);
    }

    private void assertAddress(AddressB11FK address) {
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((String)"bionetoonefk_a", (String)address.getAddressId());
        Assert.assertEquals((String)"123, New street", (String)address.getStreet());
        PersonB11FK pp = address.getPerson();
        Assert.assertNotNull((Object)pp);
        Assert.assertEquals((String)"bionetoonefk_1", (String)pp.getPersonId());
        Assert.assertEquals((String)"Amresh", (String)pp.getPersonName());
    }

    private void assertPersonnelAfterUpdate(PersonB11FK pAfterMerge) {
        Assert.assertNotNull((Object)pAfterMerge);
        Assert.assertEquals((String)"Saurabh", (String)pAfterMerge.getPersonName());
        AddressB11FK addressAfterMerge = pAfterMerge.getAddress();
        Assert.assertNotNull((Object)addressAfterMerge);
        Assert.assertEquals((String)"Brand New Street", (String)addressAfterMerge.getStreet());
        PersonB11FK pp = addressAfterMerge.getPerson();
        Assert.assertNotNull((Object)pp);
        Assert.assertEquals((String)"bionetoonefk_1", (String)pp.getPersonId());
        Assert.assertEquals((String)"Saurabh", (String)pp.getPersonName());
    }

    @After
    public void tearDown() throws Exception {
        super.close();
    }
}

