/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.query;

import com.impetus.kundera.client.DummyDatabase;
import com.impetus.kundera.query.PersonEntityNameAnnotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class PersonEntityNameTest {
    private static final String PU = "patest";
    private EntityManagerFactory emf;
    private EntityManager em;
    protected Map<String, String> propertyMap = null;

    @Before
    public void setUp() throws Exception {
        this.propertyMap = new HashMap<String, String>();
        this.propertyMap.put("index.home.dir", "./lucene");
        this.emf = Persistence.createEntityManagerFactory((String)PU, this.propertyMap);
        this.em = this.emf.createEntityManager();
    }

    @Test
    public void test() throws Exception {
        PersonEntityNameAnnotation p1 = this.prepareData("1", 10);
        PersonEntityNameAnnotation p2 = this.prepareData("2", 20);
        PersonEntityNameAnnotation p3 = this.prepareData("3", 15);
        TypedQuery findQuery = this.em.createQuery("Select p from PF p", PersonEntityNameAnnotation.class);
        List allPersons = findQuery.getResultList();
        Assert.assertNotNull((Object)allPersons);
        findQuery = this.em.createQuery("Select p from PF p where p.personName = vivek");
        allPersons = findQuery.getResultList();
        Assert.assertNotNull((Object)allPersons);
        findQuery = this.em.createQuery("Select p.age from PF p where p.personName = vivek");
        allPersons = findQuery.getResultList();
        Assert.assertNotNull((Object)allPersons);
        this.em.persist((Object)p1);
        this.em.persist((Object)p2);
        this.em.persist((Object)p3);
        PersonEntityNameAnnotation personWithKey = new PersonEntityNameAnnotation();
        personWithKey.setPersonId("111");
        this.em.persist((Object)personWithKey);
        this.em.clear();
        PersonEntityNameAnnotation p = this.findById(PersonEntityNameAnnotation.class, "1", this.em);
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((String)"vivek", (String)p.getPersonName());
        Assert.assertEquals((Object)PersonEntityNameAnnotation.Day.THURSDAY, (Object)p.getDay());
        this.em.clear();
        String qry = "Select p.personId,p.personName from PF p where p.personId >= 1";
        Query q = this.em.createQuery(qry);
        List persons = q.getResultList();
        this.assertFindByName(this.em, "PersonEntityNameAnnotation", PersonEntityNameAnnotation.class, "vivek", "personName");
        String deleteQuery = "DELETE from PF";
        q = this.em.createQuery(deleteQuery);
        q.executeUpdate();
    }

    @After
    public void tearDown() throws Exception {
        this.em.close();
        this.emf.close();
        DummyDatabase.INSTANCE.dropDatabase();
    }

    private PersonEntityNameAnnotation prepareData(String rowKey, int age) {
        PersonEntityNameAnnotation o = new PersonEntityNameAnnotation();
        o.setPersonId(rowKey);
        o.setPersonName("vivek");
        o.setAge(age);
        o.setDay(PersonEntityNameAnnotation.Day.THURSDAY);
        return o;
    }

    private <E> E findById(Class<E> clazz, Object rowKey, EntityManager em) {
        return (E)em.find(clazz, rowKey);
    }

    private <E> void assertFindByName(EntityManager em, String clazz, E e, String name, String fieldName) {
        String query = "Select p from PF p where p." + fieldName + " = " + name;
        Query q = em.createQuery(query);
        List results = q.getResultList();
        Assert.assertNotNull((Object)results);
        Assert.assertFalse((boolean)results.isEmpty());
        Assert.assertEquals((int)3, (int)results.size());
    }

    private <E> String getPersonName(E e, Object result) {
        return ((PersonEntityNameAnnotation)result).getPersonName();
    }
}

