/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.query;

import com.impetus.kundera.client.DummyDatabase;
import com.impetus.kundera.entity.PersonnelDTO;
import com.impetus.kundera.metadata.model.KunderaMetadata;
import com.impetus.kundera.query.Person;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class PersonTest {
    private static final String PU = "patest";
    private EntityManagerFactory emf;
    private EntityManager em;
    protected Map propertyMap = null;

    @Before
    public void setUp() throws Exception {
        KunderaMetadata.INSTANCE.setApplicationMetadata(null);
        this.emf = Persistence.createEntityManagerFactory((String)PU, (Map)this.propertyMap);
        this.em = this.emf.createEntityManager();
    }

    @Test
    public void testInsertions() throws Exception {
        Person p1 = this.prepareData("1", 10);
        Person p2 = this.prepareData("2", 20);
        Person p3 = this.prepareData("3", 15);
        TypedQuery findQuery = this.em.createQuery("Select p from Person p", Person.class);
        List allPersons = findQuery.getResultList();
        Assert.assertNotNull((Object)allPersons);
        findQuery = this.em.createQuery("Select p from Person p where p.personName = vivek");
        allPersons = findQuery.getResultList();
        Assert.assertNotNull((Object)allPersons);
        findQuery = this.em.createQuery("Select p.age from Person p where p.personName = vivek");
        allPersons = findQuery.getResultList();
        Assert.assertNotNull((Object)allPersons);
        this.em.persist((Object)p1);
        this.em.persist((Object)p2);
        this.em.persist((Object)p3);
        Person personWithKey = new Person();
        personWithKey.setPersonId("111");
        this.em.persist((Object)personWithKey);
        this.em.clear();
        Person p = this.findById(Person.class, "1", this.em);
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((String)"vivek", (String)p.getPersonName());
        Assert.assertEquals((Object)Person.Day.THURSDAY, (Object)p.getDay());
        this.em.clear();
        String qry = "Select p.personId,p.personName from Person p where p.personId >= 1";
        Query q = this.em.createQuery(qry);
        List persons = q.getResultList();
        this.assertFindByName(this.em, "Person", Person.class, "vivek", "personName");
        String deleteQuery = "DELETE from Person";
        q = this.em.createQuery(deleteQuery);
        q.executeUpdate();
    }

    @Test
    public void testUpdation() throws Exception {
        Person p1 = this.prepareData("1", 10);
        Person p2 = this.prepareData("2", 20);
        Person p3 = this.prepareData("3", 15);
        this.em.persist((Object)p1);
        this.em.persist((Object)p2);
        this.em.persist((Object)p3);
        this.em.clear();
        Person p = this.findById(Person.class, "1", this.em);
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((String)"vivek", (String)p.getPersonName());
        p.setPersonName("newvivek");
        this.em.merge((Object)p);
        this.assertUpdation(this.em, "Person", Person.class, "vivek", "newvivek", "personName");
    }

    @Test
    public void testDeletion() throws Exception {
        Person p1 = this.prepareData("1", 10);
        Person p2 = this.prepareData("2", 20);
        Person p3 = this.prepareData("3", 15);
        this.em.persist((Object)p1);
        this.em.persist((Object)p2);
        this.em.persist((Object)p3);
        Person p = this.findById(Person.class, "1", this.em);
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((String)"vivek", (String)p.getPersonName());
        this.em.remove((Object)p);
        this.em.clear();
        TypedQuery query = this.em.createQuery("Select p from Person p", Person.class);
        List results = query.getResultList();
        Assert.assertNotNull((Object)query);
        Assert.assertNotNull((Object)results);
    }

    @Test
    public void testRefresh() throws Exception {
        Person p1 = this.prepareData("1", 10);
        Person p2 = this.prepareData("2", 20);
        Person p3 = this.prepareData("3", 15);
        this.em.persist((Object)p1);
        this.em.persist((Object)p2);
        this.em.persist((Object)p3);
        Person pp1 = this.prepareData("1", 10);
        Person pp2 = this.prepareData("2", 20);
        Person pp3 = this.prepareData("3", 15);
        Assert.assertTrue((boolean)this.em.contains((Object)pp1));
        Assert.assertTrue((boolean)this.em.contains((Object)pp2));
        Assert.assertTrue((boolean)this.em.contains((Object)pp3));
        this.em.detach((Object)pp1);
        this.em.detach((Object)pp2);
        Assert.assertFalse((boolean)this.em.contains((Object)pp1));
        Assert.assertFalse((boolean)this.em.contains((Object)pp2));
        Assert.assertTrue((boolean)this.em.contains((Object)pp3));
        this.em.clear();
        this.em = this.emf.createEntityManager();
        Object o1 = this.em.find(Person.class, (Object)"1");
        this.em.refresh(o1);
        Object oo1 = this.em.find(Person.class, (Object)"1");
        Assert.assertTrue((boolean)this.em.contains(o1));
    }

    @Test
    public void testTypedQuery() {
        Person p1 = this.prepareData("1", 10);
        Person p2 = this.prepareData("2", 20);
        Person p3 = this.prepareData("3", 15);
        this.em.persist((Object)p1);
        this.em.persist((Object)p2);
        this.em.persist((Object)p3);
        TypedQuery query = this.em.createQuery("Select p from Person p", Person.class);
        List results = query.getResultList();
        Assert.assertNotNull((Object)query);
        Assert.assertNotNull((Object)results);
    }

    @Test
    public void testGenericTypedQuery() {
        Person p1 = this.prepareData("1", 10);
        Person p2 = this.prepareData("2", 20);
        Person p3 = this.prepareData("3", 15);
        this.em.persist((Object)p1);
        this.em.persist((Object)p2);
        this.em.persist((Object)p3);
        TypedQuery query = this.em.createQuery("Select p from Person p", Object.class);
        List results = query.getResultList();
        Assert.assertNotNull((Object)query);
        Assert.assertNotNull((Object)results);
    }

    @Test
    public void testInvalidTypedQuery() {
        Person p1 = this.prepareData("1", 10);
        Person p2 = this.prepareData("2", 20);
        Person p3 = this.prepareData("3", 15);
        this.em.persist((Object)p1);
        this.em.persist((Object)p2);
        this.em.persist((Object)p3);
        TypedQuery query = null;
        try {
            query = this.em.createQuery("Select p from Person p", PersonnelDTO.class);
            Assert.fail((String)"Should have gone to catch block, as it is an invalid scenario!");
        }
        catch (IllegalArgumentException iaex) {
            Assert.assertNull(query);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.em.close();
        this.emf.close();
        DummyDatabase.INSTANCE.dropDatabase();
    }

    private Person prepareData(String rowKey, int age) {
        Person o = new Person();
        o.setPersonId(rowKey);
        o.setPersonName("vivek");
        o.setAge(age);
        o.setDay(Person.Day.THURSDAY);
        return o;
    }

    private <E> E findById(Class<E> clazz, Object rowKey, EntityManager em) {
        return (E)em.find(clazz, rowKey);
    }

    private <E> void assertFindByName(EntityManager em, String clazz, E e, String name, String fieldName) {
        String query = "Select p from " + clazz + " p where p." + fieldName + " = " + name;
        Query q = em.createQuery(query);
        List results = q.getResultList();
        Assert.assertNotNull((Object)results);
        Assert.assertFalse((boolean)results.isEmpty());
        Assert.assertEquals((int)3, (int)results.size());
    }

    protected <E> void assertUpdation(EntityManager em, String clazz, E e, String oldName, String newName, String fieldName) {
        Query q = em.createQuery("Select p from " + clazz + " p where p." + fieldName + " = " + oldName);
        List results = q.getResultList();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((int)2, (int)results.size());
        q = em.createQuery("Select p from " + clazz + " p where p." + fieldName + " = " + newName);
        results = q.getResultList();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertNotSame((Object)oldName, (Object)this.getPersonName(e, results.get(0)));
        Assert.assertEquals((String)newName, (String)this.getPersonName(e, results.get(0)));
    }

    private <E> String getPersonName(E e, Object result) {
        return ((Person)result).getPersonName();
    }
}

