/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.polyglot.tests;

import com.impetus.kundera.polyglot.entities.AddressU11FK;
import com.impetus.kundera.polyglot.entities.PersonU11FK;
import com.impetus.kundera.polyglot.tests.PersonAddressTestBase;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OOUPolyglotTest
extends PersonAddressTestBase {
    @Before
    public void setUp() throws Exception {
        super.init();
    }

    @Test
    public void testCRUD() {
        this.executeAllTests();
    }

    @Override
    protected void insert() {
        try {
            PersonU11FK person = new PersonU11FK();
            AddressU11FK address = new AddressU11FK();
            person.setPersonId("unionetoonefk_1");
            person.setPersonName("Amresh");
            address.setAddressId("unionetoonefk_a");
            address.setStreet("123, New street");
            person.setAddress(address);
            this.dao.insert((Object)person);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Override
    protected void find() {
        try {
            PersonU11FK p = (PersonU11FK)this.dao.findPerson(PersonU11FK.class, (Object)"unionetoonefk_1");
            this.assertPersonBeforeUpdate(p);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Override
    protected void findPersonByIdColumn() {
        PersonU11FK p = (PersonU11FK)this.dao.findPersonByIdColumn(PersonU11FK.class, (Object)"unionetoonefk_1");
        this.assertPersonBeforeUpdate(p);
    }

    @Override
    protected void findPersonByName() {
        List persons = this.dao.findPersonByName(PersonU11FK.class, "Amresh");
        this.assertPersons(persons);
    }

    @Override
    protected void findAddressByIdColumn() {
        AddressU11FK a = (AddressU11FK)this.dao.findAddressByIdColumn(AddressU11FK.class, (Object)"unionetoonefk_a");
        this.assertAddressBeforeUpdate(a);
    }

    @Override
    protected void findAddressByStreet() {
        List adds = this.dao.findAddressByStreet(AddressU11FK.class, "123, New street");
        Assert.assertNotNull((Object)adds);
        Assert.assertFalse((boolean)adds.isEmpty());
        Assert.assertTrue((adds.size() == 1 ? 1 : 0) != 0);
        this.assertAddressBeforeUpdate((AddressU11FK)adds.get(0));
    }

    @Override
    protected void update() {
        try {
            PersonU11FK p = (PersonU11FK)this.dao.findPerson(PersonU11FK.class, (Object)"unionetoonefk_1");
            Assert.assertNotNull((Object)p);
            p.setPersonName("Saurabh");
            AddressU11FK address = p.getAddress();
            address.setStreet("Brand New Street");
            p.setAddress(address);
            this.dao.merge((Object)p);
            PersonU11FK pAfterMerge = (PersonU11FK)this.dao.findPerson(PersonU11FK.class, (Object)"unionetoonefk_1");
            this.assertPersonAfterUpdate(pAfterMerge);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Override
    protected void remove() {
        try {
            PersonU11FK p = (PersonU11FK)this.dao.findPerson(PersonU11FK.class, (Object)"unionetoonefk_1");
            Assert.assertNotNull((Object)p);
            this.dao.remove((Object)"unionetoonefk_1", PersonU11FK.class);
            PersonU11FK pAfterRemoval = (PersonU11FK)this.dao.findPerson(PersonU11FK.class, (Object)"unionetoonefk_1");
            Assert.assertNull((Object)pAfterRemoval);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @After
    public void tearDown() throws Exception {
        super.close();
    }

    private void assertPersonBeforeUpdate(PersonU11FK p) {
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((String)"unionetoonefk_1", (String)p.getPersonId());
        Assert.assertEquals((String)"Amresh", (String)p.getPersonName());
        this.assertAddressBeforeUpdate(p.getAddress());
    }

    private void assertAddressBeforeUpdate(AddressU11FK add) {
        Assert.assertNotNull((Object)add);
        String addressId = add.getAddressId();
        String street = add.getStreet();
        Assert.assertNotNull((Object)addressId);
        Assert.assertEquals((String)"unionetoonefk_a", (String)addressId);
        Assert.assertEquals((String)"123, New street", (String)street);
    }

    private void assertPersonAfterUpdate(PersonU11FK pAfterMerge) {
        Assert.assertNotNull((Object)pAfterMerge);
        Assert.assertEquals((String)"Saurabh", (String)pAfterMerge.getPersonName());
        AddressU11FK addressAfterMerge = pAfterMerge.getAddress();
        Assert.assertNotNull((Object)addressAfterMerge);
        Assert.assertEquals((String)"Brand New Street", (String)addressAfterMerge.getStreet());
    }

    private void assertPersons(List<PersonU11FK> persons) {
        Assert.assertNotNull(persons);
        Assert.assertFalse((boolean)persons.isEmpty());
        Assert.assertTrue((persons.size() == 1 ? 1 : 0) != 0);
        PersonU11FK person = persons.get(0);
        this.assertPersonBeforeUpdate(person);
    }
}

