/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.CoreTestUtilities;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.KunderaMetadata;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.polyglot.entities.AddressB11FK;
import com.impetus.kundera.polyglot.entities.AddressB1M;
import com.impetus.kundera.polyglot.entities.AddressBM1;
import com.impetus.kundera.polyglot.entities.AddressU11FK;
import com.impetus.kundera.polyglot.entities.AddressU1M;
import com.impetus.kundera.polyglot.entities.AddressUM1;
import com.impetus.kundera.polyglot.entities.AddressUMM;
import com.impetus.kundera.polyglot.entities.PersonB11FK;
import com.impetus.kundera.polyglot.entities.PersonB1M;
import com.impetus.kundera.polyglot.entities.PersonBM1;
import com.impetus.kundera.polyglot.entities.PersonU11FK;
import com.impetus.kundera.polyglot.entities.PersonU1M;
import com.impetus.kundera.polyglot.entities.PersonUM1;
import com.impetus.kundera.polyglot.entities.PersonUMM;
import com.impetus.kundera.polyglot.entities.PersonUMMByMap;
import com.impetus.kundera.proxy.ProxyHelper;
import com.impetus.kundera.query.CoreTestEntityReader;
import com.impetus.kundera.utils.LuceneCleanupUtilities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class EntityReaderTest {
    private static final String PU = "patest";
    private EntityManagerFactory emf;
    private EntityManager em;

    @Before
    public void setUp() throws Exception {
        KunderaMetadata.INSTANCE.setApplicationMetadata(null);
        this.emf = Persistence.createEntityManagerFactory((String)PU);
        this.em = this.emf.createEntityManager();
    }

    @Test
    public void testOneToOne() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        AddressU11FK address = new AddressU11FK();
        address.setAddressId("addr1");
        address.setStreet("street");
        PersonU11FK p1 = new PersonU11FK();
        p1.setPersonName("vivek");
        p1.setPersonId("1");
        p1.setAddress(address);
        this.em.persist((Object)p1);
        PersistenceDelegator delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        HashMap<String, String> relationMap = new HashMap<String, String>();
        relationMap.put("ADDRESS_ID", "addr1");
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(PersonU11FK.class);
        p1.setAddress(null);
        CoreTestEntityReader reader = new CoreTestEntityReader();
        reader.recursivelyFindEntities((Object)p1, relationMap, metadata, delegator, false);
        Assert.assertNotNull((Object)p1.getAddress());
        Assert.assertTrue((boolean)ProxyHelper.isKunderaProxy((Object)p1.getAddress()));
        p1.setAddress(null);
        reader.recursivelyFindEntities((Object)p1, relationMap, metadata, delegator, true);
        Assert.assertNotNull((Object)p1.getAddress());
        Assert.assertFalse((boolean)ProxyHelper.isKunderaProxy((Object)p1.getAddress()));
    }

    @Test
    public void testBiOneToOne() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        AddressB11FK address = new AddressB11FK();
        address.setAddressId("addr1");
        address.setStreet("street");
        PersonB11FK p1 = new PersonB11FK();
        p1.setPersonName("vivek");
        p1.setPersonId("1");
        p1.setAddress(address);
        this.em.persist((Object)p1);
        PersistenceDelegator delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        HashMap<String, String> relationMap = new HashMap<String, String>();
        relationMap.put("ADDRESS_ID", "addr1");
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(PersonB11FK.class);
        p1.setAddress(null);
        CoreTestEntityReader reader = new CoreTestEntityReader();
        reader.recursivelyFindEntities((Object)p1, relationMap, metadata, delegator, false);
        Assert.assertNotNull((Object)p1.getAddress());
        Assert.assertTrue((boolean)ProxyHelper.isKunderaProxy((Object)p1.getAddress()));
        p1.setAddress(null);
        reader.recursivelyFindEntities((Object)p1, relationMap, metadata, delegator, true);
        Assert.assertNotNull((Object)p1.getAddress());
        Assert.assertFalse((boolean)ProxyHelper.isKunderaProxy((Object)p1.getAddress()));
        Assert.assertEquals((Object)p1, (Object)p1.getAddress().getPerson());
    }

    @Test
    public void testManyToOne() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        PersonUM1 person1 = new PersonUM1();
        person1.setPersonId("person1");
        person1.setPersonName("vivek");
        PersonUM1 person2 = new PersonUM1();
        person2.setPersonId("person2");
        person2.setPersonName("vivek");
        AddressUM1 address = new AddressUM1();
        address.setAddressId("addr1");
        address.setStreet("streetmto1");
        person1.setAddress(address);
        person2.setAddress(address);
        this.em.persist((Object)person1);
        this.em.persist((Object)person2);
        PersistenceDelegator delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        HashMap<String, String> relationMap = new HashMap<String, String>();
        relationMap.put("ADDRESS_ID", "addr1");
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(PersonUM1.class);
        CoreTestEntityReader reader = new CoreTestEntityReader();
        person1.setAddress(null);
        reader.recursivelyFindEntities((Object)person1, relationMap, metadata, delegator, false);
        Assert.assertNotNull((Object)person1.getAddress());
        Assert.assertTrue((boolean)ProxyHelper.isKunderaProxy((Object)person1.getAddress()));
        person1.setAddress(null);
        reader.recursivelyFindEntities((Object)person1, relationMap, metadata, delegator, true);
        Assert.assertNotNull((Object)person1.getAddress());
        Assert.assertFalse((boolean)ProxyHelper.isKunderaProxy((Object)person1.getAddress()));
    }

    @Test
    public void testBiManyToOne() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        PersonBM1 person1 = new PersonBM1();
        person1.setPersonId("person1");
        person1.setPersonName("vivek");
        PersonBM1 person2 = new PersonBM1();
        person2.setPersonId("person2");
        person2.setPersonName("vivek");
        AddressBM1 address = new AddressBM1();
        address.setAddressId("addr1");
        address.setStreet("streetmto1");
        person1.setAddress(address);
        person2.setAddress(address);
        this.em.persist((Object)person1);
        this.em.persist((Object)person2);
        PersistenceDelegator delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        HashMap<String, String> relationMap = new HashMap<String, String>();
        relationMap.put("ADDRESS_ID", "addr1");
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(PersonBM1.class);
        CoreTestEntityReader reader = new CoreTestEntityReader();
        person1.setAddress(null);
        reader.recursivelyFindEntities((Object)person1, relationMap, metadata, delegator, false);
        Assert.assertNotNull((Object)person1.getAddress());
        Assert.assertTrue((boolean)ProxyHelper.isKunderaProxy((Object)person1.getAddress()));
        person1.setAddress(null);
        reader.recursivelyFindEntities((Object)person1, relationMap, metadata, delegator, true);
        Assert.assertNotNull((Object)person1.getAddress());
        Assert.assertFalse((boolean)ProxyHelper.isKunderaProxy((Object)person1.getAddress()));
    }

    @Test
    public void testManyToMany() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        PersonUMM person = new PersonUMM();
        person.setPersonId("person1");
        person.setPersonName("personName");
        AddressUMM address = new AddressUMM();
        address.setAddressId("addr1");
        address.setStreet("mtmstreet");
        HashSet<AddressUMM> addresses = new HashSet<AddressUMM>();
        addresses.add(address);
        person.setAddresses(addresses);
        this.em.persist((Object)person);
        PersistenceDelegator delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        HashMap<String, String> relationMap = new HashMap<String, String>();
        relationMap.put("ADDRESS_ID", "addr1");
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(PersonUMM.class);
        CoreTestEntityReader reader = new CoreTestEntityReader();
        person.setAddresses(null);
        reader.recursivelyFindEntities((Object)person, relationMap, metadata, delegator, false);
        Assert.assertNotNull((Object)person.getAddresses());
        Assert.assertTrue((boolean)ProxyHelper.isKunderaProxyCollection((Object)person.getAddresses()));
        reader.recursivelyFindEntities((Object)person, relationMap, metadata, delegator, true);
        Assert.assertTrue((boolean)person.getAddresses().isEmpty());
    }

    @Test
    public void testManyToManyByMap() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        PersonUMMByMap person = new PersonUMMByMap();
        person.setPersonId("person1");
        person.setPersonName("personName");
        AddressUMM address = new AddressUMM();
        address.setAddressId("addr1");
        address.setStreet("mtmstreet");
        HashMap<String, AddressUMM> addresses = new HashMap<String, AddressUMM>();
        addresses.put("addr1", address);
        person.setAddresses(addresses);
        this.em.persist((Object)person);
        PersistenceDelegator delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        HashMap<String, String> relationMap = new HashMap<String, String>();
        relationMap.put("ADDRESS_ID", "addr1");
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(PersonUMMByMap.class);
        CoreTestEntityReader reader = new CoreTestEntityReader();
        person.setAddresses(null);
        reader.recursivelyFindEntities((Object)person, relationMap, metadata, delegator, false);
        Assert.assertNotNull((Object)person.getAddresses());
        Assert.assertTrue((boolean)ProxyHelper.isKunderaProxyCollection((Object)person.getAddresses()));
        reader.recursivelyFindEntities((Object)person, relationMap, metadata, delegator, true);
        Assert.assertTrue((boolean)person.getAddresses().isEmpty());
    }

    @Test
    public void testOneToMany() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        AddressU1M address1 = new AddressU1M();
        address1.setAddressId("addr1");
        address1.setStreet("street");
        AddressU1M address2 = new AddressU1M();
        address2.setAddressId("addr1");
        address2.setStreet("street");
        HashSet<AddressU1M> addressess = new HashSet<AddressU1M>();
        addressess.add(address1);
        addressess.add(address2);
        PersonU1M p1 = new PersonU1M();
        p1.setPersonName("vivek");
        p1.setPersonId("1");
        p1.setAddresses(addressess);
        this.em.persist((Object)p1);
        PersistenceDelegator delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        Map relationMap = null;
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(PersonU1M.class);
        CoreTestEntityReader reader = new CoreTestEntityReader();
        p1.setAddresses(null);
        reader.recursivelyFindEntities((Object)p1, relationMap, metadata, delegator, false);
        Assert.assertNotNull((Object)p1.getAddresses());
        Assert.assertTrue((boolean)ProxyHelper.isKunderaProxyCollection((Object)p1.getAddresses()));
        reader.recursivelyFindEntities((Object)p1, relationMap, metadata, delegator, true);
        Assert.assertNotNull((Object)p1.getAddresses());
        Assert.assertFalse((boolean)ProxyHelper.isKunderaProxyCollection((Object)p1.getAddresses()));
    }

    @Test
    public void testBiOneToMany() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        AddressB1M address1 = new AddressB1M();
        address1.setAddressId("addr1");
        address1.setStreet("street");
        AddressB1M address2 = new AddressB1M();
        address2.setAddressId("addr1");
        address2.setStreet("street");
        HashSet<AddressB1M> addressess = new HashSet<AddressB1M>();
        addressess.add(address1);
        addressess.add(address2);
        PersonB1M p1 = new PersonB1M();
        p1.setPersonName("vivek");
        p1.setPersonId("1");
        p1.setAddresses(addressess);
        this.em.persist((Object)p1);
        PersistenceDelegator delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        Map relationMap = null;
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(PersonB1M.class);
        CoreTestEntityReader reader = new CoreTestEntityReader();
        p1.setAddresses(null);
        reader.recursivelyFindEntities((Object)p1, relationMap, metadata, delegator, false);
        Assert.assertNotNull((Object)p1.getAddresses());
        Assert.assertTrue((boolean)ProxyHelper.isKunderaProxyCollection((Object)p1.getAddresses()));
        p1.setAddresses(null);
        reader.recursivelyFindEntities((Object)p1, relationMap, metadata, delegator, true);
        Assert.assertNotNull((Object)p1.getAddresses());
        Assert.assertFalse((boolean)ProxyHelper.isKunderaProxyCollection((Object)p1.getAddresses()));
    }

    @After
    public void tearDown() {
        if (this.emf != null) {
            this.emf.close();
        }
        if (this.em != null) {
            this.em.close();
        }
        LuceneCleanupUtilities.cleanLuceneDirectory((String)PU);
    }
}

