/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.model;

import com.impetus.kundera.client.CoreTestClient;
import com.impetus.kundera.client.CoreTestClientFactory;
import com.impetus.kundera.configure.ClientFactoryConfiguraton;
import com.impetus.kundera.configure.SchemaConfiguration;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.MetadataBuilder;
import com.impetus.kundera.metadata.model.ApplicationMetadata;
import com.impetus.kundera.metadata.model.ClientMetadata;
import com.impetus.kundera.metadata.model.Column;
import com.impetus.kundera.metadata.model.Employe;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.KunderaMetadata;
import com.impetus.kundera.metadata.model.KunderaUser;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.event.PersonEventDispatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EntityMetadataTest {
    private String persistenceUnit = "metaDataTest";

    @Before
    public void setUp() throws Exception {
        this.getEntityManagerFactory(null);
    }

    @After
    public void tearDown() throws Exception {
        KunderaMetadata.INSTANCE.setApplicationMetadata(null);
    }

    private EntityManagerFactoryImpl getEntityManagerFactory(String property) {
        ClientMetadata clientMetadata = new ClientMetadata();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("persistenceUnitName", this.persistenceUnit);
        props.put("kundera.client.lookup.class", CoreTestClientFactory.class.getName());
        props.put("kundera.nodes", "localhost");
        props.put("kundera.port", "9160");
        props.put("kundera.keyspace", "KunderaMetaDataTest");
        clientMetadata.setLuceneIndexDir(null);
        KunderaMetadata.INSTANCE.setApplicationMetadata(null);
        ApplicationMetadata appMetadata = KunderaMetadata.INSTANCE.getApplicationMetadata();
        PersistenceUnitMetadata puMetadata = new PersistenceUnitMetadata();
        puMetadata.setPersistenceUnitName(this.persistenceUnit);
        Properties p = new Properties();
        p.putAll((Map<?, ?>)props);
        puMetadata.setProperties(p);
        HashMap<String, PersistenceUnitMetadata> metadata = new HashMap<String, PersistenceUnitMetadata>();
        metadata.put(this.persistenceUnit, puMetadata);
        appMetadata.addPersistenceUnitMetadata(metadata);
        HashMap clazzToPu = new HashMap();
        ArrayList<String> pus = new ArrayList<String>();
        pus.add(this.persistenceUnit);
        clazzToPu.put(Employe.class.getName(), pus);
        clazzToPu.put(KunderaUser.class.getName(), pus);
        appMetadata.setClazzToPuMap(clazzToPu);
        MetadataBuilder metadataBuilder = new MetadataBuilder(this.persistenceUnit, CoreTestClient.class.getSimpleName(), null);
        MetamodelImpl metaModel = new MetamodelImpl();
        metaModel.addEntityMetadata(Employe.class, metadataBuilder.buildEntityMetadata(Employe.class));
        metaModel.addEntityMetadata(KunderaUser.class, metadataBuilder.buildEntityMetadata(KunderaUser.class));
        appMetadata.getMetamodelMap().put(this.persistenceUnit, metaModel);
        metaModel.assignManagedTypes(appMetadata.getMetaModelBuilder(this.persistenceUnit).getManagedTypes());
        metaModel.assignEmbeddables(appMetadata.getMetaModelBuilder(this.persistenceUnit).getEmbeddables());
        metaModel.assignMappedSuperClass(appMetadata.getMetaModelBuilder(this.persistenceUnit).getMappedSuperClassTypes());
        String[] persistenceUnits = new String[]{this.persistenceUnit};
        new ClientFactoryConfiguraton(null, persistenceUnits).configure();
        new SchemaConfiguration(null, persistenceUnits).configure();
        return null;
    }

    @Test
    public void testCallbackMethodsForLucene() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("index.home.dir", "lucene");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"kunderatest", props);
        EntityManager em = emf.createEntityManager();
        EntityMetadata m = KunderaMetadataManager.getEntityMetadata(PersonEventDispatch.class);
        Assert.assertNotNull((Object)m.toString());
        PersonEventDispatch person = new PersonEventDispatch();
        person.setFirstName("vivek");
        person.setLastName("mishra");
        person.setPersonId("1_p");
        em.persist((Object)person);
        em.clear();
        PersonEventDispatch result = (PersonEventDispatch)em.find(PersonEventDispatch.class, (Object)"1_p");
        Assert.assertEquals((Object)result.getLastName(), (Object)"Post Load");
        this.onFindCallBack(em);
        em.refresh((Object)result);
        Assert.assertEquals((Object)result.getLastName(), (Object)"Post Load");
        em.close();
        emf.close();
    }

    private void onFindCallBack(EntityManager em) {
        String query = "Selcet p from PersonEventDispatch p";
        Query q = em.createQuery(query);
        List results = q.getResultList();
        Assert.assertNotNull((Object)results);
        Assert.assertFalse((boolean)results.isEmpty());
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testColumn() {
        try {
            Column column = new Column("EMP_NAME", Employe.class.getDeclaredField("empName"));
            column.setIndexable(true);
            Assert.assertTrue((boolean)column.isIndexable());
            Assert.assertEquals((Object)"empName", (Object)column.getField().getName());
            Assert.assertEquals((Object)"EMP_NAME", (Object)column.getName());
            column = new Column("AGE", Employe.class.getDeclaredField("age"), true);
            Assert.assertTrue((boolean)column.isIndexable());
            Assert.assertEquals((Object)"age", (Object)column.getField().getName());
            Assert.assertEquals((Object)"AGE", (Object)column.getName());
        }
        catch (SecurityException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

