/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.model;

import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.Column;
import com.impetus.kundera.metadata.model.Employe;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.event.PersonEventDispatch;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EntityMetadataTest {
    private String persistenceUnit = "metaDataTest";
    private EntityManagerFactoryImpl emf;

    @Before
    public void setUp() throws Exception {
        this.emf = this.getEntityManagerFactory(null);
    }

    @After
    public void tearDown() throws Exception {
    }

    private EntityManagerFactoryImpl getEntityManagerFactory(String property) {
        return (EntityManagerFactoryImpl)Persistence.createEntityManagerFactory((String)this.persistenceUnit);
    }

    @Test
    public void testCallbackMethodsForLucene() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("index.home.dir", "lucene");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"kunderatest", props);
        EntityManager em = emf.createEntityManager();
        EntityMetadata m = KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)((EntityManagerFactoryImpl)emf).getKunderaMetadataInstance(), PersonEventDispatch.class);
        Assert.assertNotNull((Object)m.toString());
        PersonEventDispatch person = new PersonEventDispatch();
        person.setFirstName("vivek");
        person.setLastName("mishra");
        person.setPersonId("1_p");
        em.persist((Object)person);
        em.clear();
        PersonEventDispatch result = (PersonEventDispatch)em.find(PersonEventDispatch.class, (Object)"1_p");
        Assert.assertEquals((Object)result.getLastName(), (Object)"Post Load");
        this.onFindCallBack(em);
        em.refresh((Object)result);
        Assert.assertEquals((Object)result.getLastName(), (Object)"Post Load");
        em.close();
        emf.close();
    }

    private void onFindCallBack(EntityManager em) {
        String query = "Select p from PersonEventDispatch p";
        Query q = em.createQuery(query);
        List results = q.getResultList();
        Assert.assertNotNull((Object)results);
        Assert.assertFalse((boolean)results.isEmpty());
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testColumn() {
        try {
            Column column = new Column("EMP_NAME", Employe.class.getDeclaredField("empName"));
            column.setIndexable(true);
            Assert.assertTrue((boolean)column.isIndexable());
            Assert.assertEquals((Object)"empName", (Object)column.getField().getName());
            Assert.assertEquals((Object)"EMP_NAME", (Object)column.getName());
            column = new Column("AGE", Employe.class.getDeclaredField("age"), true);
            Assert.assertTrue((boolean)column.isIndexable());
            Assert.assertEquals((Object)"age", (Object)column.getField().getName());
            Assert.assertEquals((Object)"AGE", (Object)column.getName());
        }
        catch (SecurityException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

