/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.polyglot.tests;

import com.impetus.kundera.polyglot.entities.AddressUM1;
import com.impetus.kundera.polyglot.entities.PersonUM1;
import com.impetus.kundera.polyglot.tests.PersonAddressTestBase;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MOUPolyglotTest
extends PersonAddressTestBase {
    @Before
    public void setUp() throws Exception {
        super.init();
    }

    @Test
    public void testCRUD() {
        this.executeAllTests();
    }

    @Override
    protected void insert() {
        PersonUM1 person1 = new PersonUM1();
        person1.setPersonId("unimanytoone_1");
        person1.setPersonName("Amresh");
        PersonUM1 person2 = new PersonUM1();
        person2.setPersonId("unimanytoone_2");
        person2.setPersonName("Vivek");
        AddressUM1 address = new AddressUM1();
        address.setAddressId("unimanytoone_a");
        address.setStreet("AAAAAAAAAAAAA");
        person1.setAddress(address);
        person2.setAddress(address);
        HashSet<PersonUM1> persons = new HashSet<PersonUM1>();
        persons.add(person1);
        persons.add(person2);
        this.dao.savePersons(persons);
    }

    @Override
    protected void find() {
        PersonUM1 p1 = (PersonUM1)this.dao.findPerson(PersonUM1.class, (Object)"unimanytoone_1");
        this.assertPerson1(p1);
        PersonUM1 p2 = (PersonUM1)this.dao.findPerson(PersonUM1.class, (Object)"unimanytoone_2");
        this.assertPerson2(p2);
    }

    @Override
    protected void findPersonByIdColumn() {
        PersonUM1 p = (PersonUM1)this.dao.findPersonByIdColumn(PersonUM1.class, (Object)"unimanytoone_1");
        this.assertPerson1(p);
    }

    @Override
    protected void findPersonByName() {
        List persons = this.dao.findPersonByName(PersonUM1.class, "Amresh");
        Assert.assertNotNull((Object)persons);
        Assert.assertFalse((boolean)persons.isEmpty());
        Assert.assertTrue((persons.size() == 1 ? 1 : 0) != 0);
        PersonUM1 person = (PersonUM1)persons.get(0);
        this.assertPerson1(person);
    }

    @Override
    protected void findAddressByIdColumn() {
        AddressUM1 a = (AddressUM1)this.dao.findAddressByIdColumn(AddressUM1.class, (Object)"unimanytoone_a");
        this.assertAddress(a);
    }

    @Override
    protected void findAddressByStreet() {
        List adds = this.dao.findAddressByStreet(AddressUM1.class, "AAAAAAAAAAAAA");
        Assert.assertNotNull((Object)adds);
        Assert.assertFalse((boolean)adds.isEmpty());
        Assert.assertTrue((adds.size() == 1 ? 1 : 0) != 0);
        this.assertAddress((AddressUM1)adds.get(0));
    }

    @Override
    protected void update() {
        PersonUM1 p1 = (PersonUM1)this.dao.findPerson(PersonUM1.class, (Object)"unimanytoone_1");
        Assert.assertNotNull((Object)p1);
        p1.setPersonName("Saurabh");
        p1.getAddress().setStreet("Brand New Street");
        this.dao.merge((Object)p1);
        PersonUM1 p1AfterMerge = (PersonUM1)this.dao.findPerson(PersonUM1.class, (Object)"unimanytoone_1");
        Assert.assertNotNull((Object)p1AfterMerge);
        Assert.assertEquals((String)"Saurabh", (String)p1AfterMerge.getPersonName());
        Assert.assertEquals((String)"Brand New Street", (String)p1AfterMerge.getAddress().getStreet());
        PersonUM1 p2 = (PersonUM1)this.dao.findPerson(PersonUM1.class, (Object)"unimanytoone_2");
        Assert.assertNotNull((Object)p2);
        p2.setPersonName("Prateek");
        this.dao.merge((Object)p2);
        PersonUM1 p2AfterMerge = (PersonUM1)this.dao.findPerson(PersonUM1.class, (Object)"unimanytoone_2");
        Assert.assertNotNull((Object)p2AfterMerge);
        Assert.assertEquals((String)"Prateek", (String)p2AfterMerge.getPersonName());
    }

    @Override
    protected void remove() {
        this.dao.remove((Object)"unimanytoone_1", PersonUM1.class);
        PersonUM1 p1AfterRemoval = (PersonUM1)this.dao.findPerson(PersonUM1.class, (Object)"unimanytoone_1");
        Assert.assertNull((Object)p1AfterRemoval);
        this.dao.remove((Object)"unimanytoone_2", PersonUM1.class);
        PersonUM1 p2AfterRemoval = (PersonUM1)this.dao.findPerson(PersonUM1.class, (Object)"unimanytoone_2");
        Assert.assertNull((Object)p2AfterRemoval);
    }

    @After
    public void tearDown() throws Exception {
        super.close();
    }

    private void assertPerson2(PersonUM1 p2) {
        Assert.assertNotNull((Object)p2);
        Assert.assertEquals((String)"unimanytoone_2", (String)p2.getPersonId());
        Assert.assertEquals((String)"Vivek", (String)p2.getPersonName());
        AddressUM1 add2 = p2.getAddress();
        this.assertAddress(add2);
    }

    private void assertPerson1(PersonUM1 p1) {
        Assert.assertNotNull((Object)p1);
        Assert.assertEquals((String)"unimanytoone_1", (String)p1.getPersonId());
        Assert.assertEquals((String)"Amresh", (String)p1.getPersonName());
        AddressUM1 add = p1.getAddress();
        this.assertAddress(add);
    }

    private void assertAddress(AddressUM1 add2) {
        Assert.assertNotNull((Object)add2);
        Assert.assertEquals((String)"unimanytoone_a", (String)add2.getAddressId());
        Assert.assertEquals((String)"AAAAAAAAAAAAA", (String)add2.getStreet());
    }
}

