/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.polyglot.tests;

import com.impetus.kundera.polyglot.entities.AddressBMM;
import com.impetus.kundera.polyglot.entities.PersonBMM;
import com.impetus.kundera.polyglot.tests.PersonAddressTestBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MMBPolyglotTest
extends PersonAddressTestBase {
    @Before
    public void setUp() throws Exception {
        super.init();
    }

    @Test
    public void testCRUD() {
        this.executeAllTests();
    }

    @Override
    protected void insert() {
        PersonBMM person1 = new PersonBMM();
        person1.setPersonId("bimanytomany_1");
        person1.setPersonName("Amresh");
        PersonBMM person2 = new PersonBMM();
        person2.setPersonId("bimanytomany_2");
        person2.setPersonName("Vivek");
        AddressBMM address1 = new AddressBMM();
        address1.setAddressId("bimanytomany_a");
        address1.setStreet("AAAAAAAAAAAAA");
        AddressBMM address2 = new AddressBMM();
        address2.setAddressId("bimanytomany_b");
        address2.setStreet("BBBBBBBBBBBBBBB");
        AddressBMM address3 = new AddressBMM();
        address3.setAddressId("bimanytomany_c");
        address3.setStreet("CCCCCCCCCCC");
        HashSet<AddressBMM> person1Addresses = new HashSet<AddressBMM>();
        HashSet<AddressBMM> person2Addresses = new HashSet<AddressBMM>();
        person1Addresses.add(address1);
        person1Addresses.add(address2);
        person2Addresses.add(address2);
        person2Addresses.add(address3);
        person1.setAddresses(person1Addresses);
        person2.setAddresses(person2Addresses);
        HashSet<PersonBMM> persons = new HashSet<PersonBMM>();
        persons.add(person1);
        persons.add(person2);
        this.dao.savePersons(persons);
    }

    @Override
    protected void find() {
        PersonBMM person1 = (PersonBMM)this.dao.findPerson(PersonBMM.class, (Object)"bimanytomany_1");
        this.assertPerson1(person1);
        PersonBMM person2 = (PersonBMM)this.dao.findPerson(PersonBMM.class, (Object)"bimanytomany_2");
        this.assertPerson2(person2);
    }

    @Override
    protected void findPersonByIdColumn() {
        PersonBMM p1 = (PersonBMM)this.dao.findPersonByIdColumn(PersonBMM.class, (Object)"bimanytomany_1");
        this.assertPerson1(p1);
        PersonBMM p2 = (PersonBMM)this.dao.findPersonByIdColumn(PersonBMM.class, (Object)"bimanytomany_2");
        this.assertPerson2(p2);
    }

    @Override
    protected void findPersonByName() {
        List persons = this.dao.findPersonByName(PersonBMM.class, "Amresh");
        Assert.assertNotNull((Object)persons);
        Assert.assertFalse((boolean)persons.isEmpty());
        Assert.assertTrue((persons.size() == 1 ? 1 : 0) != 0);
        this.assertPerson1((PersonBMM)persons.get(0));
    }

    @Override
    protected void findAddressByIdColumn() {
    }

    @Override
    protected void findAddressByStreet() {
    }

    @Override
    protected void update() {
    }

    @Override
    protected void remove() {
    }

    @After
    public void tearDown() throws Exception {
        super.close();
    }

    private void assertPerson2(PersonBMM person2) {
        Assert.assertNotNull((Object)person2);
        Assert.assertEquals((String)"bimanytomany_2", (String)person2.getPersonId());
        Assert.assertEquals((String)"Vivek", (String)person2.getPersonName());
        Set addresses2 = person2.getAddresses();
        Assert.assertNotNull((Object)addresses2);
        Assert.assertFalse((boolean)addresses2.isEmpty());
        Assert.assertEquals((int)2, (int)addresses2.size());
        AddressBMM address21 = (AddressBMM)addresses2.toArray()[0];
        Assert.assertNotNull((Object)address21);
        AddressBMM address22 = (AddressBMM)addresses2.toArray()[1];
        Assert.assertNotNull((Object)address22);
    }

    private void assertPerson1(PersonBMM person1) {
        Assert.assertNotNull((Object)person1);
        Assert.assertEquals((String)"bimanytomany_1", (String)person1.getPersonId());
        Assert.assertEquals((String)"Amresh", (String)person1.getPersonName());
        Set addresses1 = person1.getAddresses();
        Assert.assertNotNull((Object)addresses1);
        Assert.assertFalse((boolean)addresses1.isEmpty());
        Assert.assertEquals((int)2, (int)addresses1.size());
        AddressBMM address11 = (AddressBMM)addresses1.toArray()[0];
        Assert.assertNotNull((Object)address11);
    }
}

