/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.polyglot.tests;

import com.impetus.kundera.polyglot.entities.AddressU1M;
import com.impetus.kundera.polyglot.entities.PersonU1M;
import com.impetus.kundera.polyglot.tests.PersonAddressTestBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OMUPolyglotTest
extends PersonAddressTestBase {
    @Before
    public void setUp() throws Exception {
        super.init();
    }

    @Test
    public void testCRUD() {
        this.executeAllTests();
    }

    @Override
    protected void insert() {
        PersonU1M personnel = new PersonU1M();
        personnel.setPersonId("unionetomany_1");
        personnel.setPersonName("Amresh");
        HashSet<AddressU1M> addresses = new HashSet<AddressU1M>();
        AddressU1M address1 = new AddressU1M();
        address1.setAddressId("unionetomany_a");
        address1.setStreet("AAAAAAAAAAAAA");
        AddressU1M address2 = new AddressU1M();
        address2.setAddressId("unionetomany_b");
        address2.setStreet("BBBBBBBBBBB");
        addresses.add(address1);
        addresses.add(address2);
        personnel.setAddresses(addresses);
        this.dao.insert((Object)personnel);
    }

    @Override
    protected void find() {
        PersonU1M p = (PersonU1M)this.dao.findPerson(PersonU1M.class, (Object)"unionetomany_1");
        this.assertPerson(p);
    }

    @Override
    protected void findPersonByIdColumn() {
        PersonU1M p = (PersonU1M)this.dao.findPersonByIdColumn(PersonU1M.class, (Object)"unionetomany_1");
        this.assertPerson(p);
    }

    @Override
    protected void findPersonByName() {
        List persons = this.dao.findPersonByName(PersonU1M.class, "Amresh");
        Assert.assertNotNull((Object)persons);
        Assert.assertFalse((boolean)persons.isEmpty());
        Assert.assertTrue((persons.size() == 1 ? 1 : 0) != 0);
        PersonU1M person = (PersonU1M)persons.get(0);
        this.assertPerson(person);
    }

    @Override
    protected void findAddressByIdColumn() {
        AddressU1M a = (AddressU1M)this.dao.findAddressByIdColumn(AddressU1M.class, (Object)"unionetomany_a");
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((String)"unionetomany_a", (String)a.getAddressId());
        Assert.assertEquals((String)"AAAAAAAAAAAAA", (String)a.getStreet());
    }

    @Override
    protected void findAddressByStreet() {
        List adds = this.dao.findAddressByStreet(AddressU1M.class, "AAAAAAAAAAAAA");
        Assert.assertNotNull((Object)adds);
        Assert.assertFalse((boolean)adds.isEmpty());
        Assert.assertTrue((adds.size() == 1 ? 1 : 0) != 0);
        AddressU1M a = (AddressU1M)adds.get(0);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((String)"unionetomany_a", (String)a.getAddressId());
        Assert.assertEquals((String)"AAAAAAAAAAAAA", (String)a.getStreet());
    }

    @Override
    protected void update() {
        try {
            PersonU1M p = (PersonU1M)this.dao.findPerson(PersonU1M.class, (Object)"unionetomany_1");
            Assert.assertNotNull((Object)p);
            Assert.assertEquals((int)2, (int)p.getAddresses().size());
            p.setPersonName("Saurabh");
            for (AddressU1M address : p.getAddresses()) {
                address.setStreet("Brand New Street");
            }
            this.dao.merge((Object)p);
            this.assertPersonAfterUpdate();
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Override
    protected void remove() {
        try {
            this.dao.remove((Object)"unionetomany_1", PersonU1M.class);
            PersonU1M pAfterRemoval = (PersonU1M)this.dao.findPerson(PersonU1M.class, (Object)"unionetomany_1");
            Assert.assertNull((Object)pAfterRemoval);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @After
    public void tearDown() throws Exception {
        super.close();
    }

    private void assertPerson(PersonU1M p) {
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((String)"unionetomany_1", (String)p.getPersonId());
        Assert.assertEquals((String)"Amresh", (String)p.getPersonName());
        Set adds = p.getAddresses();
        Assert.assertNotNull((Object)adds);
        Assert.assertFalse((boolean)adds.isEmpty());
        Assert.assertEquals((int)2, (int)adds.size());
        for (AddressU1M address : adds) {
            Assert.assertNotNull((Object)address.getStreet());
        }
    }

    private void assertPersonAfterUpdate() {
        PersonU1M pAfterMerge = (PersonU1M)this.dao.findPerson(PersonU1M.class, (Object)"unionetomany_1");
        Assert.assertNotNull((Object)pAfterMerge);
        Assert.assertEquals((String)"Saurabh", (String)pAfterMerge.getPersonName());
        Assert.assertEquals((int)2, (int)pAfterMerge.getAddresses().size());
        for (AddressU1M address : pAfterMerge.getAddresses()) {
            Assert.assertEquals((String)"Brand New Street", (String)address.getStreet());
        }
    }
}

