/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.index;

import com.impetus.kundera.client.CoreTestClient;
import com.impetus.kundera.index.IndexManager;
import com.impetus.kundera.index.Indexer;
import com.impetus.kundera.index.LuceneIndexer;
import com.impetus.kundera.index.LuceneIndexingException;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.entities.EmbeddableEntity;
import com.impetus.kundera.metadata.entities.EmbeddableEntityTwo;
import com.impetus.kundera.metadata.entities.SingularEntityEmbeddable;
import com.impetus.kundera.metadata.model.Employe;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.PropertyIndex;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.query.CoreIndexer;
import com.impetus.kundera.query.Person;
import com.impetus.kundera.utils.LuceneCleanupUtilities;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class IndexManagerTest {
    private static final String LUCENE_DIR_PATH = "./lucene";
    private EntityManagerFactory emf;
    private EntityManager em;

    @Before
    public void setup() {
        this.emf = Persistence.createEntityManagerFactory((String)"patest");
        this.em = this.emf.createEntityManager();
    }

    @Test
    public void testCRUD() {
        Map results;
        LuceneIndexer indexer = LuceneIndexer.getInstance((String)LUCENE_DIR_PATH);
        IndexManager ixManager = new IndexManager((Indexer)indexer, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance(), Person.class);
        Person p = new Person();
        p.setAge(32);
        p.setDay(Person.Day.TUESDAY);
        p.setPersonId("p1");
        Assert.assertNotNull((Object)ixManager.getIndexer());
        Assert.assertEquals((Object)indexer, (Object)ixManager.getIndexer());
        ixManager.write(metadata, (Object)p);
        String luceneQuery = "+Person.AGE:32 AND +entity.class:com.impetus.kundera.query.Person";
        try {
            results = ixManager.search(metadata.getEntityClazz(), luceneQuery, 0, 10, false);
            Assert.assertTrue((!results.isEmpty() ? 1 : 0) != 0);
        }
        catch (LuceneIndexingException liex) {
            Assert.fail();
        }
        p.setAge(35);
        ixManager.update(metadata, (Object)p, null, Person.class);
        luceneQuery = "+Person.AGE:35 AND +entity.class:com.impetus.kundera.query.Person";
        try {
            results = ixManager.search(metadata.getEntityClazz(), luceneQuery, 1);
            Assert.assertTrue((!results.isEmpty() ? 1 : 0) != 0);
        }
        catch (LuceneIndexingException liex) {
            Assert.fail();
        }
        ixManager.remove(metadata, (Object)p, (Object)"p1");
        luceneQuery = "+Person.AGE:32 AND +entity.class:com.impetus.kundera.query.Person";
        try {
            results = ixManager.search(metadata.getEntityClazz(), luceneQuery, 0, 10, false);
            Assert.assertTrue((boolean)results.isEmpty());
        }
        catch (LuceneIndexingException liex) {
            Assert.fail();
        }
    }

    @Test
    public void testEmbeddable() {
        LuceneIndexer indexer = LuceneIndexer.getInstance((String)LUCENE_DIR_PATH);
        IndexManager ixManager = new IndexManager((Indexer)indexer, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance(), SingularEntityEmbeddable.class);
        SingularEntityEmbeddable entity = new SingularEntityEmbeddable();
        entity.setKey(Integer.valueOf(1));
        entity.setName("entity");
        entity.setField("name");
        EmbeddableEntity embed1 = new EmbeddableEntity();
        embed1.setField("embeddedField1");
        EmbeddableEntityTwo embed2 = new EmbeddableEntityTwo();
        embed2.setField(Float.valueOf(1.0f));
        embed2.setName("name");
        entity.setEmbeddableEntity(embed1);
        entity.setEmbeddableEntityTwo(embed2);
        this.em.persist((Object)entity);
        String luceneQuery = "+entity.class:com.impetus.kundera.metadata.entities.SingularEntityEmbeddable AND +SingularEntityEmbeddable.embeddedField:embeddedField1";
        Map results = ixManager.search(metadata.getEntityClazz(), luceneQuery, 0, 10, false);
        Assert.assertFalse((boolean)results.isEmpty());
    }

    @Test
    public void testEmbeddableCustomIndexer() {
        try {
            CoreIndexer indexer = new CoreIndexer();
            IndexManager ixManager = new IndexManager((Indexer)indexer, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
            Map clients = (Map)this.em.getDelegate();
            CoreTestClient client = (CoreTestClient)clients.get("patest");
            client.setIndexManager(ixManager);
            EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance(), SingularEntityEmbeddable.class);
            SingularEntityEmbeddable entity = new SingularEntityEmbeddable();
            entity.setKey(Integer.valueOf(1));
            entity.setName("entity");
            entity.setField("name");
            EmbeddableEntity embed1 = new EmbeddableEntity();
            embed1.setField("embeddedField1");
            EmbeddableEntityTwo embed2 = new EmbeddableEntityTwo();
            embed2.setField(Float.valueOf(1.0f));
            embed2.setName("name");
            entity.setEmbeddableEntity(embed1);
            entity.setEmbeddableEntityTwo(embed2);
            this.em.persist((Object)entity);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPropertyIndex() {
        try {
            PropertyIndex pi = new PropertyIndex(Employe.class.getDeclaredField("empName"), "EMP_NAME", "ASC");
            pi.setBoost(1.2f);
            Assert.assertEquals((Object)Float.valueOf(1.2f), (Object)Float.valueOf(pi.getBoost()));
            Assert.assertEquals((String)"ASC", (String)pi.getIndexType());
        }
        catch (SecurityException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        LuceneCleanupUtilities.cleanDir((String)LUCENE_DIR_PATH);
    }
}

