/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.index;

import com.impetus.kundera.index.LuceneIndexingException;
import com.impetus.kundera.index.lucene.Indexer;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.PropertyIndex;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessorHelper;
import java.io.CharArrayReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LetterTokenizer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentIndexer
implements Indexer {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentIndexer.class);
    protected static final String INDEX_NAME = "kundera-alpha";
    private static final long UUID = 6077004083174677888L;
    protected static final String DEFAULT_SEARCHABLE_FIELD = "6077004083174677888.default_property";
    protected static final String SUPERCOLUMN_INDEX = "6077004083174677888.entity.super.indexname";
    protected static int docNumber = 1;
    protected Analyzer analyzer;
    protected Tokenizer tokenizer;

    public DocumentIndexer() {
        String empty = "";
        this.analyzer = new StandardAnalyzer(Version.LUCENE_CURRENT);
        this.tokenizer = new LetterTokenizer(Version.LUCENE_34, (Reader)new CharArrayReader("".toCharArray()));
    }

    protected Document prepareDocumentForSuperColumn(EntityMetadata metadata, Object object, String embeddedColumnName, String parentId, Class<?> clazz) {
        Document currentDoc = new Document();
        this.addEntityClassToDocument(metadata, object, currentDoc);
        this.addSuperColumnNameToDocument(embeddedColumnName, currentDoc);
        this.addParentKeyToDocument(parentId, currentDoc, clazz);
        return currentDoc;
    }

    protected void addParentKeyToDocument(String parentId, Document currentDoc, Class<?> clazz) {
        if (parentId != null) {
            org.apache.lucene.document.Field luceneField = new org.apache.lucene.document.Field("6077004083174677888.parent.id", parentId, Field.Store.YES, Field.Index.ANALYZED_NO_NORMS);
            currentDoc.add((IndexableField)luceneField);
            org.apache.lucene.document.Field fieldClass = new org.apache.lucene.document.Field("6077004083174677888.parent.class", clazz.getCanonicalName().toLowerCase(), Field.Store.YES, Field.Index.ANALYZED);
            currentDoc.add((IndexableField)fieldClass);
        }
    }

    protected void createSuperColumnDocument(EntityMetadata metadata, Object object, Document currentDoc, Object embeddedObject, EmbeddableType superColumn) {
        Set attributes = superColumn.getAttributes();
        for (Attribute attr : attributes) {
            Field field = (Field)attr.getJavaMember();
            String colName = field.getName();
            String indexName = metadata.getIndexName();
            this.addFieldToDocument(embeddedObject, currentDoc, field, colName, indexName);
        }
        this.addEntityFieldsToDocument(metadata, object, currentDoc);
    }

    protected void indexSuperColumn(EntityMetadata metadata, Object object, Document currentDoc, Object embeddedObject, EmbeddableType superColumn) {
        Set attributes = superColumn.getAttributes();
        for (Attribute attr : attributes) {
            Field field = (Field)attr.getJavaMember();
            String colName = field.getName();
            String indexName = metadata.getIndexName();
            this.addFieldToDocument(embeddedObject, currentDoc, field, colName, indexName);
        }
        this.addEntityFieldsToDocument(metadata, object, currentDoc);
        this.indexDocument(metadata, currentDoc);
    }

    private void addSuperColumnNameToDocument(String superColumnName, Document currentDoc) {
        org.apache.lucene.document.Field luceneField = new org.apache.lucene.document.Field(SUPERCOLUMN_INDEX, superColumnName, Field.Store.YES, Field.Index.NO);
        currentDoc.add((IndexableField)luceneField);
    }

    protected void addEntityFieldsToDocument(EntityMetadata metadata, Object object, Document document) {
        String indexName = metadata.getIndexName();
        Map indexProperties = metadata.getIndexProperties();
        for (String columnName : indexProperties.keySet()) {
            PropertyIndex index = (PropertyIndex)indexProperties.get(columnName);
            Field property = index.getProperty();
            String propertyName = index.getName();
            this.addFieldToDocument(object, document, property, propertyName, indexName);
        }
    }

    protected void addEntityClassToDocument(EntityMetadata metadata, Object object, Document document) {
        try {
            Object id = PropertyAccessorHelper.getId((Object)object, (EntityMetadata)metadata);
            org.apache.lucene.document.Field luceneField = new org.apache.lucene.document.Field("6077004083174677888.entity.id", id.toString(), Field.Store.YES, Field.Index.ANALYZED);
            document.add((IndexableField)luceneField);
            luceneField = new org.apache.lucene.document.Field("6077004083174677888.kundera.id", this.getKunderaId(metadata, id), Field.Store.YES, Field.Index.ANALYZED);
            document.add((IndexableField)luceneField);
            luceneField = new org.apache.lucene.document.Field("entity.class", metadata.getEntityClazz().getCanonicalName().toLowerCase(), Field.Store.YES, Field.Index.ANALYZED);
            document.add((IndexableField)luceneField);
            luceneField = new org.apache.lucene.document.Field("timestamp", System.currentTimeMillis() + "", Field.Store.YES, Field.Index.NO);
            document.add((IndexableField)luceneField);
            luceneField = new org.apache.lucene.document.Field("6077004083174677888.entity.indexname", metadata.getIndexName(), Field.Store.NO, Field.Index.ANALYZED_NO_NORMS);
            document.add((IndexableField)luceneField);
            luceneField = new org.apache.lucene.document.Field(this.getCannonicalPropertyName(metadata.getEntityClazz().getSimpleName(), ((AbstractAttribute)metadata.getIdAttribute()).getJPAColumnName()), id.toString(), Field.Store.YES, Field.Index.ANALYZED_NO_NORMS);
            document.add((IndexableField)luceneField);
        }
        catch (PropertyAccessException e) {
            throw new IllegalArgumentException("Id could not be read from object " + object);
        }
    }

    private void addFieldToDocument(Object object, Document document, Field field, String colName, String indexName) {
        try {
            Object obj = PropertyAccessorHelper.getObject((Object)object, (Field)field);
            if (obj != null) {
                org.apache.lucene.document.Field luceneField = new org.apache.lucene.document.Field(this.getCannonicalPropertyName(indexName, colName), obj.toString(), Field.Store.YES, Field.Index.ANALYZED_NO_NORMS);
                document.add((IndexableField)luceneField);
            } else {
                LOG.warn("value is null for field" + field.getName());
            }
        }
        catch (PropertyAccessException e) {
            LOG.error("Error in accessing field, Caused by:" + e.getMessage());
            throw new LuceneIndexingException("Error in accessing field:" + field.getName(), (Throwable)e);
        }
    }

    public Map<String, Object> search(String query, Class<?> parentClass, EntityMetadata parentMetadata, Class<?> childClass, EntityMetadata childMetadata, Object entityId, int start, int count) {
        return null;
    }

    protected String getKunderaId(EntityMetadata metadata, Object id) {
        return metadata.getEntityClazz().getCanonicalName() + "~" + id;
    }

    protected String getCannonicalPropertyName(String indexName, String propertyName) {
        return indexName + "." + propertyName;
    }

    protected abstract void indexDocument(EntityMetadata var1, Document var2);
}

