/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.index;

import com.impetus.kundera.index.LuceneIndexer;
import com.impetus.kundera.index.LuceneIndexingException;
import com.impetus.kundera.index.LuceneQueryUtils;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.query.Person;
import com.impetus.kundera.utils.LuceneCleanupUtilities;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class LuceneIndexerTest {
    private EntityManagerFactory emf;
    private static final String LUCENE_DIR_PATH = "./lucene";

    @Before
    public void setup() {
        this.emf = Persistence.createEntityManagerFactory((String)"patest");
    }

    @Test
    public void testGetInstance() {
        LuceneIndexer indexer = LuceneIndexer.getInstance((String)LUCENE_DIR_PATH);
        Assert.assertNotNull((Object)indexer);
        indexer.close();
    }

    @Test
    public void testSearchWithNoResult() {
        LuceneIndexer indexer = LuceneIndexer.getInstance((String)LUCENE_DIR_PATH);
        Assert.assertNotNull((Object)indexer);
        String luceneQuery = LuceneQueryUtils.getQuery((String)"addressId", (String)"address", (String)"addressId", (String)"1");
        try {
            indexer.search(luceneQuery, 0, 10, false);
        }
        catch (LuceneIndexingException liex) {
            Assert.assertNotNull((Object)liex.getMessage());
        }
        indexer.close();
    }

    @Test
    public void invalidLuceneQueryTest() {
        LuceneIndexer indexer = LuceneIndexer.getInstance((String)LUCENE_DIR_PATH);
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance(), Person.class);
        Person p = new Person();
        p.setAge(32);
        p.setDay(Person.Day.TUESDAY);
        p.setPersonId("p1");
        indexer.index(metadata, (MetamodelImpl)((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance().getApplicationMetadata().getMetamodel("patest"), (Object)p);
        Assert.assertNotNull((Object)indexer);
        String luceneQuery = "Invalid lucene query";
        try {
            indexer.search("Invalid lucene query", 0, 10, false);
        }
        catch (LuceneIndexingException liex) {
            Assert.assertEquals((String)"Error while parsing Lucene Query Invalid lucene query", (String)liex.getMessage());
        }
        indexer.close();
    }

    @Test
    public void invalidValidQueryTest() {
        LuceneIndexer indexer = LuceneIndexer.getInstance((String)LUCENE_DIR_PATH);
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance(), Person.class);
        Person p = new Person();
        p.setAge(32);
        p.setDay(Person.Day.TUESDAY);
        p.setPersonId("p1");
        indexer.index(metadata, (MetamodelImpl)((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance().getApplicationMetadata().getMetamodel("patest"), (Object)p);
        indexer.flush();
        Assert.assertNotNull((Object)indexer);
        String luceneQuery = "+Person.AGE:32 AND +entity.class:com.impetus.kundera.query.Person";
        try {
            Map results = indexer.search(luceneQuery, 0, 10, false);
            Assert.assertTrue((!results.isEmpty() ? 1 : 0) != 0);
        }
        catch (LuceneIndexingException liex) {
            Assert.fail();
        }
        indexer.close();
    }

    @Test
    public void testOnUnsupportedMethods() {
        String luceneQuery = "+Person.AGE:32 AND +entity.class:com.impetus.kundera.query.Person";
        LuceneIndexer indexer = LuceneIndexer.getInstance((String)LUCENE_DIR_PATH);
        EntityMetadata m = KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance(), Person.class);
        try {
            indexer.index(Person.class, m, null, null, null);
            Assert.fail((String)"Should have gone to catch block!");
        }
        catch (UnsupportedOperationException uoex) {
            Assert.assertNotNull((Object)uoex);
        }
        try {
            indexer.search(m.getEntityClazz(), m, luceneQuery, 0, 100);
            Assert.fail((String)"Should have gone to catch block!");
        }
        catch (UnsupportedOperationException uoex) {
            Assert.assertNotNull((Object)uoex);
        }
        try {
            indexer.unIndex(Person.class, null, m, (MetamodelImpl)((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance().getApplicationMetadata().getMetamodel("patest"));
            Assert.fail((String)"Should have gone to catch block!");
        }
        catch (UnsupportedOperationException uoex) {
            Assert.assertNotNull((Object)uoex);
        }
    }

    @After
    public void tearDown() {
        LuceneCleanupUtilities.cleanDir((String)LUCENE_DIR_PATH);
    }
}

