/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.query;

import com.impetus.kundera.metadata.entities.EmbeddableEntity;
import com.impetus.kundera.metadata.entities.EmbeddableEntityTwo;
import com.impetus.kundera.metadata.entities.SingularEntityEmbeddable;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.query.KunderaQuery;
import com.impetus.kundera.query.KunderaQueryParser;
import com.impetus.kundera.query.LuceneQuery;
import com.impetus.kundera.query.Person;
import com.impetus.kundera.utils.LuceneCleanupUtilities;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class LuceneQueryTest {
    private static final String LUCENE_DIR_PATH = "./lucene";
    private static final String PU = "patest";
    private EntityManagerFactory emf;
    private EntityManager em;

    @Before
    public void setUp() throws Exception {
        this.emf = Persistence.createEntityManagerFactory((String)PU);
        this.em = this.emf.createEntityManager();
    }

    @Test
    public void test() {
        String query = "Select p from Person p";
        KunderaQuery kunderaQuery = new KunderaQuery(query, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        KunderaQueryParser queryParser = new KunderaQueryParser(kunderaQuery);
        queryParser.parse();
        kunderaQuery.postParsingInit();
        LuceneQuery luceneQuery = new LuceneQuery(kunderaQuery, null, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        try {
            luceneQuery.populateEntities(null, null);
        }
        catch (UnsupportedOperationException uoex) {
            Assert.assertEquals((String)"Method not supported for Lucene indexing", (String)uoex.getMessage());
        }
        try {
            luceneQuery.recursivelyPopulateEntities(null, null);
        }
        catch (UnsupportedOperationException uoex) {
            Assert.assertEquals((String)"Method not supported for Lucene indexing", (String)uoex.getMessage());
        }
        try {
            luceneQuery.getReader();
        }
        catch (UnsupportedOperationException uoex) {
            Assert.assertEquals((String)"Method not supported for Lucene indexing", (String)uoex.getMessage());
        }
        Assert.assertEquals((int)0, (int)luceneQuery.onExecuteUpdate());
    }

    @Test
    public void testOnWhereClause() {
        Person p1 = new Person();
        p1.setAge(32);
        p1.setDay(Person.Day.TUESDAY);
        p1.setPersonId("p1");
        p1.setSalary(Double.valueOf(6000.345));
        this.em.persist((Object)p1);
        this.em.clear();
        Person p2 = new Person();
        p2.setAge(24);
        p2.setDay(Person.Day.MONDAY);
        p2.setPersonId("p2");
        p2.setSalary(Double.valueOf(8000.345));
        this.em.persist((Object)p2);
        this.em.clear();
        String query = "Select p from Person p WHERE p.salary > 500.0";
        TypedQuery findQuery = this.em.createQuery(query, Person.class);
        List allPersons = findQuery.getResultList();
        Assert.assertNotNull((Object)allPersons);
        Assert.assertEquals((int)2, (int)allPersons.size());
        query = "Select p from Person p WHERE p.salary >= 500.0";
        findQuery = this.em.createQuery(query, Person.class);
        allPersons = findQuery.getResultList();
        Assert.assertNotNull((Object)allPersons);
        Assert.assertEquals((int)2, (int)allPersons.size());
        query = "Select p from Person p WHERE p.salary = 6000.345";
        findQuery = this.em.createQuery(query, Person.class);
        allPersons = findQuery.getResultList();
        Assert.assertNotNull((Object)allPersons);
        Assert.assertEquals((int)1, (int)allPersons.size());
        query = "Select p from Person p WHERE p.salary <= 7000.345";
        findQuery = this.em.createQuery(query, Person.class);
        allPersons = findQuery.getResultList();
        Assert.assertNotNull((Object)allPersons);
        Assert.assertEquals((int)1, (int)allPersons.size());
        Assert.assertEquals((Object)new Integer(32), (Object)((Person)allPersons.get(0)).getAge());
        query = "Select p from Person p WHERE p.salary < 7000.345";
        findQuery = this.em.createQuery(query, Person.class);
        allPersons = findQuery.getResultList();
        Assert.assertNotNull((Object)allPersons);
        Assert.assertEquals((int)1, (int)allPersons.size());
        Assert.assertEquals((Object)new Integer(32), (Object)((Person)allPersons.get(0)).getAge());
        query = "Select p from Person p WHERE p.salary < 6000.345";
        findQuery = this.em.createQuery(query, Person.class);
        allPersons = findQuery.getResultList();
        Assert.assertEquals((int)0, (int)allPersons.size());
        query = "Select p from Person p WHERE p.salary < 6000.345";
        findQuery = this.em.createQuery(query, Person.class);
        allPersons = findQuery.getResultList();
        Assert.assertEquals((int)0, (int)allPersons.size());
        query = "Select p from Person p WHERE p.salary > -2000";
        findQuery = this.em.createQuery(query, Person.class);
        allPersons = findQuery.getResultList();
        Assert.assertEquals((int)2, (int)allPersons.size());
        query = "Select p from Person p WHERE p.salary = -200.00";
        findQuery = this.em.createQuery(query, Person.class);
        allPersons = findQuery.getResultList();
        Assert.assertEquals((int)0, (int)allPersons.size());
        query = "Select p from Person p WHERE p.salary >= -200.00";
        findQuery = this.em.createQuery(query, Person.class);
        allPersons = findQuery.getResultList();
        Assert.assertEquals((int)2, (int)allPersons.size());
        query = "Select p from Person p WHERE p.salary < -400.00";
        findQuery = this.em.createQuery(query, Person.class);
        allPersons = findQuery.getResultList();
        Assert.assertEquals((int)0, (int)allPersons.size());
    }

    @Test
    public void testOnUpdate() {
        Person p1 = new Person();
        p1.setPersonName("vivek");
        p1.setAge(32);
        p1.setDay(Person.Day.TUESDAY);
        p1.setPersonId("p1");
        p1.setSalary(Double.valueOf(6000.345));
        this.em.persist((Object)p1);
        this.em.clear();
        Person p = (Person)this.em.find(Person.class, (Object)"p1");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((String)"vivek", (String)p.getPersonName());
        p.setAge(12);
        p.setPersonName("newvivek");
        this.em.merge((Object)p);
        this.em.clear();
        Query findQuery = this.em.createQuery("Select p from Person p WHERE p.personName = vivek");
        List allPersons = findQuery.getResultList();
        Assert.assertEquals((int)0, (int)allPersons.size());
        findQuery = this.em.createQuery("Select p from Person p WHERE p.personName = newvivek");
        allPersons = findQuery.getResultList();
        Assert.assertEquals((Object)new Integer(12), (Object)((Person)allPersons.get(0)).getAge());
    }

    @Test
    public void testEmbeddable() {
        SingularEntityEmbeddable entity = new SingularEntityEmbeddable();
        entity.setKey(Integer.valueOf(1));
        entity.setName("entity");
        entity.setField("name");
        EmbeddableEntity embed1 = new EmbeddableEntity();
        embed1.setField("embeddedField1");
        EmbeddableEntityTwo embed2 = new EmbeddableEntityTwo();
        embed2.setField(Float.valueOf(1.0f));
        embed2.setName("name");
        entity.setEmbeddableEntity(embed1);
        entity.setEmbeddableEntityTwo(embed2);
        this.em.persist((Object)entity);
        SingularEntityEmbeddable p = (SingularEntityEmbeddable)this.em.find(SingularEntityEmbeddable.class, (Object)1);
        Assert.assertNotNull((Object)p);
        p.getEmbeddableEntity().setField("embeddedFieldChange");
        this.em.merge((Object)p);
        p = (SingularEntityEmbeddable)this.em.find(SingularEntityEmbeddable.class, (Object)1);
        Assert.assertEquals((String)"embeddedFieldChange", (String)p.getEmbeddableEntity().getField());
    }

    @Test
    public void testCollection() {
        SingularEntityEmbeddable entity = new SingularEntityEmbeddable();
        entity.setKey(Integer.valueOf(1));
        entity.setName("entity");
        entity.setField("name");
        EmbeddableEntity embed1 = new EmbeddableEntity();
        embed1.setField("embeddedField1");
        EmbeddableEntityTwo embed2 = new EmbeddableEntityTwo();
        embed2.setField(Float.valueOf(1.0f));
        embed2.setName("name");
        entity.setEmbeddableEntity(embed1);
        entity.setEmbeddableEntityTwo(embed2);
        this.em.persist((Object)entity);
        SingularEntityEmbeddable p = (SingularEntityEmbeddable)this.em.find(SingularEntityEmbeddable.class, (Object)1);
        Assert.assertNotNull((Object)p);
        p.getEmbeddableEntity().setField("embeddedFieldChange");
        this.em.merge((Object)p);
        p = (SingularEntityEmbeddable)this.em.find(SingularEntityEmbeddable.class, (Object)1);
        Assert.assertEquals((String)"embeddedFieldChange", (String)p.getEmbeddableEntity().getField());
    }

    @After
    public void tearDown() throws Exception {
        this.em.close();
        this.emf.close();
        LuceneCleanupUtilities.cleanDir((String)LUCENE_DIR_PATH);
    }
}

