/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.index;

import com.impetus.kundera.cache.ElementCollectionCacheManager;
import com.impetus.kundera.index.DocumentIndexer;
import com.impetus.kundera.index.LuceneIndexingException;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessorHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexer
extends DocumentIndexer {
    private static Logger log = LoggerFactory.getLogger(LuceneIndexer.class);
    private static IndexWriter w;
    private static IndexReader reader;
    private static Directory index;
    private static boolean isInitialized;
    private static LuceneIndexer indexer;
    private static boolean readyForCommit;
    private static String luceneDirPath;

    private LuceneIndexer(String lucDirPath) {
        try {
            luceneDirPath = lucDirPath;
            File file = new File(luceneDirPath);
            if (file.exists()) {
                FSDirectory sourceDir = FSDirectory.open((File)this.getIndexDirectory());
                index = new RAMDirectory((Directory)sourceDir, IOContext.DEFAULT);
            } else {
                index = new RAMDirectory();
            }
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_34, this.analyzer);
            LogDocMergePolicy logDocMergePolicy = new LogDocMergePolicy();
            logDocMergePolicy.setMergeFactor(1000);
            indexWriterConfig.setMergePolicy((MergePolicy)logDocMergePolicy);
            w = new IndexWriter(index, indexWriterConfig);
            w.getConfig().setRAMBufferSizeMB(32.0);
        }
        catch (Exception e) {
            log.error("Error while instantiating LuceneIndexer, Caused by :.", (Throwable)e);
            throw new LuceneIndexingException((Throwable)e);
        }
    }

    public static synchronized LuceneIndexer getInstance(String lucDirPath) {
        if (indexer == null && lucDirPath != null) {
            indexer = new LuceneIndexer(lucDirPath);
        }
        return indexer;
    }

    private IndexWriter getIndexWriter() {
        return w;
    }

    private IndexReader getIndexReader() {
        this.flushInternal();
        if (reader == null) {
            try {
                if (!isInitialized) {
                    FSDirectory sourceDir = FSDirectory.open((File)this.getIndexDirectory());
                    this.copy((Directory)sourceDir, index);
                    isInitialized = true;
                }
                reader = IndexReader.open((Directory)index);
            }
            catch (IndexNotFoundException infex) {
                log.warn("No index found in given directory, caused by:", (Object)infex.getMessage());
            }
            catch (Exception e) {
                log.error("Error while instantiating LuceneIndexer, Caused by :.", (Throwable)e);
                throw new LuceneIndexingException((Throwable)e);
            }
        }
        return reader;
    }

    private File getIndexDirectory() {
        File file = new File(luceneDirPath);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        return file;
    }

    public final void index(EntityMetadata metadata, MetamodelImpl metaModel, Object object) {
        this.indexDocument(metadata, metaModel, object, null, null);
        this.onCommit();
    }

    public final void unindex(EntityMetadata metadata, Object id) throws LuceneIndexingException {
        if (log.isDebugEnabled()) {
            log.debug("Unindexing @Entity[{}] for key:{}", (Object)metadata.getEntityClazz().getName(), id);
        }
        try {
            QueryParser qp = new QueryParser(Version.LUCENE_34, "6077004083174677888.default_property", (Analyzer)new StandardAnalyzer(Version.LUCENE_34));
            qp.setLowercaseExpandedTerms(false);
            qp.setAllowLeadingWildcard(true);
            String luceneQuery = "+entity.class:" + QueryParser.escape((String)metadata.getEntityClazz().getCanonicalName().toLowerCase()) + " AND +" + this.getCannonicalPropertyName(QueryParser.escape((String)metadata.getEntityClazz().getSimpleName()), QueryParser.escape((String)((AbstractAttribute)metadata.getIdAttribute()).getJPAColumnName())) + ":" + QueryParser.escape((String)id.toString());
            Query q = qp.parse(luceneQuery);
            w.deleteDocuments(q);
            w.commit();
            w.close();
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_34, this.analyzer);
            LogDocMergePolicy logDocMergePolicy = new LogDocMergePolicy();
            logDocMergePolicy.setMergeFactor(1000);
            indexWriterConfig.setMergePolicy((MergePolicy)logDocMergePolicy);
            w = new IndexWriter(index, indexWriterConfig);
            w.getConfig().setRAMBufferSizeMB(32.0);
        }
        catch (Exception e) {
            log.error("Error while instantiating LuceneIndexer, Caused by :.", (Throwable)e);
            throw new LuceneIndexingException((Throwable)e);
        }
    }

    public final void update(EntityMetadata metadata, MetamodelImpl metaModel, Object entity, Object id, String parentId) {
        if (log.isDebugEnabled()) {
            log.debug("Updating @Entity[{}] for key:{}", (Object)metadata.getEntityClazz().getName(), id);
        }
        this.updateDocument(metadata, metaModel, entity, parentId, entity.getClass(), true);
    }

    public final Map<String, Object> search(String luceneQuery, int start, int count, boolean fetchRelation) {
        reader = this.getIndexReader();
        if (-1 == count) {
            count = 100;
        }
        if (log.isDebugEnabled()) {
            log.debug("Searching index with query[{}], start:{} , count:" + count, (Object)luceneQuery, (Object)start);
        }
        HashMap<String, Object> indexCol = new HashMap<String, Object>();
        if (reader == null) {
            return indexCol;
        }
        IndexSearcher searcher = new IndexSearcher(reader);
        QueryParser qp = new QueryParser(Version.LUCENE_34, "6077004083174677888.default_property", (Analyzer)new StandardAnalyzer(Version.LUCENE_34));
        try {
            qp.setLowercaseExpandedTerms(false);
            qp.setAllowLeadingWildcard(true);
            Query q = qp.parse(luceneQuery);
            TopDocs docs = searcher.search(q, count);
            int nullCount = 0;
            for (ScoreDoc sc : docs.scoreDocs) {
                Document doc = searcher.doc(sc.doc);
                String entityId = doc.get(fetchRelation ? "6077004083174677888.parent.id" : "6077004083174677888.entity.id");
                String superCol = doc.get("6077004083174677888.entity.super.indexname");
                if (superCol == null) {
                    superCol = "SuperCol" + nullCount++;
                }
                indexCol.put(superCol + "|" + entityId, entityId);
            }
        }
        catch (Exception e) {
            log.error("Error while parsing Lucene Query {} ", (Object)luceneQuery, (Object)e);
            throw new LuceneIndexingException((Throwable)e);
        }
        reader = null;
        return indexCol;
    }

    @Override
    public void indexDocument(EntityMetadata metadata, Document document) {
        if (log.isDebugEnabled()) {
            log.debug("Indexing document: {} for in file system using Lucene", (Object)document);
        }
        IndexWriter w = this.getIndexWriter();
        try {
            w.addDocument((Iterable)document);
        }
        catch (Exception e) {
            log.error("Error while indexing document {} into Lucene, Caused by:{} ", (Object)document, (Object)e);
            throw new LuceneIndexingException("Error while indexing document " + document + " into Lucene.", (Throwable)e);
        }
    }

    public void updateDocument(String id, Document document) {
        if (log.isDebugEnabled()) {
            log.debug("Updateing indexed document: {} for in file system using Lucene", (Object)document);
        }
        IndexWriter w = this.getIndexWriter();
        try {
            Term term = new Term("6077004083174677888.entity.id", id);
            w.updateDocument(term, (Iterable)document);
        }
        catch (LuceneIndexingException lie) {
            log.error("Error while updating LuceneIndexer, Caused by :.", (Throwable)lie);
            throw new LuceneIndexingException((Throwable)lie);
        }
        catch (IOException ioe) {
            log.error("Error while reading Lucene indexes, Caused by :.", (Throwable)ioe);
        }
    }

    private void flushInternal() {
        try {
            if (w != null && readyForCommit) {
                w.commit();
                this.copy(index, (Directory)FSDirectory.open((File)this.getIndexDirectory()));
                readyForCommit = false;
                reader = null;
                isInitialized = false;
            }
        }
        catch (Exception e) {
            log.error("Error while Flushing Lucene Indexes, Caused by: ", (Throwable)e);
            throw new LuceneIndexingException("Error while Flushing Lucene Indexes", (Throwable)e);
        }
    }

    public void close() {
        try {
            if (w != null && readyForCommit) {
                w.commit();
                this.copy(index, (Directory)FSDirectory.open((File)this.getIndexDirectory()));
            }
        }
        catch (Exception e) {
            log.error("Error while closing lucene indexes, Caused by: ", (Throwable)e);
            throw new LuceneIndexingException("Error while closing lucene indexes.", (Throwable)e);
        }
    }

    public void flush() {
    }

    public void index(EntityMetadata metadata, MetamodelImpl metaModel, Object object, String parentId, Class<?> clazz) {
        this.indexDocument(metadata, metaModel, object, parentId, clazz);
        this.onCommit();
    }

    public boolean entityExistsInIndex(Class<?> entityClass) {
        Map<String, Object> results;
        String luceneQuery = "+entity.class:" + entityClass.getCanonicalName().toLowerCase();
        try {
            results = this.search(luceneQuery, 0, 10, false);
        }
        catch (LuceneIndexingException e) {
            return false;
        }
        return results != null && !results.isEmpty();
    }

    public boolean documentExistsInIndex(EntityMetadata metadata, Object id) {
        Map<String, Object> results;
        String luceneQuery = "+entity.class:" + QueryParser.escape((String)metadata.getEntityClazz().getCanonicalName().toLowerCase()) + " AND +" + this.getCannonicalPropertyName(QueryParser.escape((String)metadata.getEntityClazz().getSimpleName()), QueryParser.escape((String)((AbstractAttribute)metadata.getIdAttribute()).getJPAColumnName())) + ":" + QueryParser.escape((String)id.toString());
        try {
            results = this.search(luceneQuery, 0, 10, false);
        }
        catch (LuceneIndexingException e) {
            results = null;
        }
        return results != null && !results.isEmpty();
    }

    private Document indexDocument(EntityMetadata metadata, MetamodelImpl metaModel, Object object, String parentId, Class<?> clazz) {
        if (log.isDebugEnabled()) {
            log.debug("Indexing @Entity[{}],{} ", (Object)metadata.getEntityClazz().getName(), object);
        }
        Document currentDoc = this.updateOrIndexDocument(metadata, metaModel, object, parentId, clazz, false);
        return currentDoc;
    }

    private Document updateOrIndexDocument(EntityMetadata metadata, MetamodelImpl metaModel, Object entity, String parentId, Class<?> clazz, boolean isUpdate) {
        if (!metadata.isIndexable()) {
            return null;
        }
        Document currentDoc = null;
        Object embeddedObject = null;
        Object rowKey = null;
        try {
            rowKey = PropertyAccessorHelper.getId((Object)entity, (EntityMetadata)metadata);
        }
        catch (PropertyAccessException e1) {
            throw new LuceneIndexingException("Can't access Primary key property from " + metadata.getEntityClazz(), (Throwable)e1);
        }
        if (metadata.getType().equals((Object)EntityMetadata.Type.SUPER_COLUMN_FAMILY)) {
            Map embeddables = metaModel.getEmbeddables(metadata.getEntityClazz());
            for (String attributeName : embeddables.keySet()) {
                EmbeddableType embeddableAttribute = (EmbeddableType)embeddables.get(attributeName);
                EntityType entityType = metaModel.entity(metadata.getEntityClazz());
                embeddedObject = PropertyAccessorHelper.getObject((Object)entity, (Field)((Field)entityType.getAttribute(attributeName).getJavaMember()));
                if (embeddedObject == null) continue;
                if (embeddedObject instanceof Collection) {
                    String elementCollectionObjectName;
                    ElementCollectionCacheManager ecCacheHandler = ElementCollectionCacheManager.getInstance();
                    if (ecCacheHandler.isCacheEmpty()) {
                        int count = 0;
                        for (Object obj : (Collection)embeddedObject) {
                            elementCollectionObjectName = attributeName + "#" + count;
                            currentDoc = this.prepareDocumentForSuperColumn(metadata, entity, elementCollectionObjectName, parentId, clazz);
                            this.createSuperColumnDocument(metadata, entity, currentDoc, obj, embeddableAttribute);
                            if (isUpdate) {
                                this.updateDocument(parentId, currentDoc);
                            } else {
                                this.indexDocument(metadata, currentDoc);
                            }
                            ++count;
                        }
                        continue;
                    }
                    int lastEmbeddedObjectCount = ecCacheHandler.getLastElementCollectionObjectCount(rowKey);
                    for (Object obj : (Collection)embeddedObject) {
                        elementCollectionObjectName = ecCacheHandler.getElementCollectionObjectName(rowKey, obj);
                        if (elementCollectionObjectName == null) {
                            elementCollectionObjectName = attributeName + "#" + ++lastEmbeddedObjectCount;
                        }
                        currentDoc = this.prepareDocumentForSuperColumn(metadata, entity, elementCollectionObjectName, parentId, clazz);
                        this.createSuperColumnDocument(metadata, entity, currentDoc, obj, embeddableAttribute);
                        if (isUpdate) {
                            this.updateDocument(parentId, currentDoc);
                            continue;
                        }
                        this.indexDocument(metadata, currentDoc);
                    }
                    continue;
                }
                currentDoc = this.prepareDocumentForSuperColumn(metadata, entity, attributeName, parentId, clazz);
                this.createSuperColumnDocument(metadata, entity, currentDoc, metaModel.isEmbeddable(embeddedObject.getClass()) ? embeddedObject : entity, embeddableAttribute);
                if (isUpdate) {
                    this.updateDocument(parentId, currentDoc);
                    continue;
                }
                this.indexDocument(metadata, currentDoc);
            }
        } else {
            currentDoc = new Document();
            this.addEntityClassToDocument(metadata, entity, currentDoc);
            this.addEntityFieldsToDocument(metadata, entity, currentDoc);
            this.addParentKeyToDocument(parentId, currentDoc, clazz);
            if (isUpdate) {
                this.updateDocument(rowKey.toString(), currentDoc);
            } else {
                this.indexDocument(metadata, currentDoc);
            }
        }
        return currentDoc;
    }

    private void onCommit() {
        isInitialized = true;
        readyForCommit = true;
    }

    public void index(Class entityClazz, EntityMetadata entityMetadata, Map<String, Object> values, Object parentId, Class parentClazz) {
        throw new UnsupportedOperationException("Method not supported");
    }

    public void unIndex(Class entityClazz, Object entity, EntityMetadata metadata, MetamodelImpl metamodel) {
        throw new UnsupportedOperationException("Method not supported");
    }

    public Map<String, Object> search(Class<?> clazz, EntityMetadata m, String luceneQuery, int start, int end) {
        throw new UnsupportedOperationException("Method not supported");
    }

    private void copy(Directory src, Directory to) throws IOException {
        for (String file : src.listAll()) {
            src.copy(to, file, file, IOContext.DEFAULT);
        }
    }

    private void updateDocument(EntityMetadata metadata, MetamodelImpl metaModel, Object entity, String parentId, Class<? extends Object> class1, boolean b) {
        this.updateOrIndexDocument(metadata, metaModel, entity, parentId, entity.getClass(), true);
        this.onCommit();
    }
}

