/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.cache.ehcache;

import com.impetus.kundera.cache.CacheException;
import com.impetus.kundera.cache.ehcache.EhCacheProvider;
import com.impetus.kundera.cache.ehcache.EhCacheWrapper;
import com.impetus.kundera.entity.PersonnelDTO;
import java.util.HashMap;
import javax.persistence.Cache;
import junit.framework.TestCase;
import org.junit.Assert;

public class EhCacheProviderTest
extends TestCase {
    EhCacheProvider cacheProvider;
    String cacheResource = "/ehcache-test.xml";
    String cacheName = "Kundera";
    PersonnelDTO person1;
    PersonnelDTO person2;

    protected void setUp() throws Exception {
        super.setUp();
        this.cacheProvider = new EhCacheProvider();
        this.person1 = new PersonnelDTO("1", "Amresh", "Singh");
        this.person2 = new PersonnelDTO("2", "Vivek", "Mishra");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.cacheProvider.shutdown();
    }

    public void testCreateCache() {
        HashMap<String, String> map;
        EhCacheProviderTest.assertNotNull((Object)this.cacheProvider);
        try {
            this.cacheProvider.init(this.cacheResource);
        }
        catch (CacheException e) {
            EhCacheProviderTest.fail((String)e.getMessage());
        }
        EhCacheProviderTest.assertNotNull((Object)this.cacheProvider.getCacheManager());
        Cache cache = null;
        try {
            cache = this.cacheProvider.createCache(this.cacheName);
        }
        catch (CacheException e) {
            EhCacheProviderTest.fail((String)e.getMessage());
        }
        EhCacheProviderTest.assertNotNull((Object)cache);
        EhCacheProviderTest.assertEquals(cache.getClass(), EhCacheWrapper.class);
        EhCacheWrapper ehCache = (EhCacheWrapper)cache;
        EhCacheProviderTest.assertEquals((int)0, (int)ehCache.size());
        ehCache.put((Object)(this.person1.getClass() + "_" + this.person1.getPersonId()), (Object)this.person1);
        EhCacheProviderTest.assertEquals((int)1, (int)ehCache.size());
        ehCache.put((Object)(this.person2.getClass() + "_" + this.person2.getPersonId()), (Object)this.person2);
        EhCacheProviderTest.assertEquals((int)2, (int)ehCache.size());
        Object o = ehCache.get((Object)(this.person1.getClass() + "_" + this.person1.getPersonId()));
        EhCacheProviderTest.assertEquals(PersonnelDTO.class, o.getClass());
        PersonnelDTO p1 = (PersonnelDTO)o;
        EhCacheProviderTest.assertNotNull((Object)p1);
        EhCacheProviderTest.assertEquals((String)"1", (String)p1.getPersonId());
        EhCacheProviderTest.assertEquals((String)"Amresh", (String)p1.getFirstName());
        EhCacheProviderTest.assertEquals((String)"Singh", (String)p1.getLastName());
        ehCache.evict(PersonnelDTO.class, (Object)(PersonnelDTO.class + "_" + this.person1.getPersonId()));
        EhCacheProviderTest.assertEquals((int)1, (int)ehCache.size());
        cache = this.cacheProvider.getCache(this.cacheName);
        Assert.assertNotNull((Object)cache);
        this.cacheProvider.clearAll();
        EhCacheProviderTest.assertEquals((int)0, (int)ehCache.size());
        Assert.assertNotNull((Object)this.cacheProvider.getCacheManager());
        try {
            map = new HashMap<String, String>();
            this.cacheProvider.init(map);
        }
        catch (CacheException e) {
            EhCacheProviderTest.fail((String)e.getMessage());
        }
        this.cacheProvider.shutdown();
        try {
            cache = this.cacheProvider.getCache(this.cacheName);
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"CacheFactory was not initialized. Call init() before creating a cache.", (Object)e.getMessage());
        }
        Assert.assertNotNull((Object)cache);
        Assert.assertNull((Object)this.cacheProvider.getCacheManager());
        try {
            map = new HashMap();
            this.cacheProvider.init(map);
        }
        catch (CacheException e) {
            EhCacheProviderTest.fail((String)e.getMessage());
        }
        this.cacheProvider.shutdown();
        try {
            map = new HashMap();
            map.put("net.sf.ehcache.configurationResourceName", "Kundera");
            this.cacheProvider.init(map);
            Assert.assertNotNull((Object)this.cacheProvider.getCacheManager());
        }
        catch (CacheException e) {
            EhCacheProviderTest.fail((String)e.getMessage());
        }
        this.cacheProvider.shutdown();
        try {
            map = new HashMap();
            map.put("net.sf.ehcache.configurationResourceName", null);
            this.cacheProvider.init(map);
            Assert.assertNotNull((Object)this.cacheProvider.getCacheManager());
        }
        catch (CacheException e) {
            EhCacheProviderTest.fail((String)e.getMessage());
        }
    }
}

