/*******************************************************************************
 * * Copyright 2012 Impetus Infotech.
 *  *
 *  * Licensed under the Apache License, Version 2.0 (the "License");
 *  * you may not use this file except in compliance with the License.
 *  * You may obtain a copy of the License at
 *  *
 *  *      http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS,
 *  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  * See the License for the specific language governing permissions and
 *  * limitations under the License.
 ******************************************************************************/
package com.impetus.kundera.cache.ehcache;

import net.sf.ehcache.Element;
import net.sf.ehcache.Status;

import org.apache.commons.lang.NotImplementedException;

import com.impetus.kundera.cache.Cache;

/**
 * Cache implementation using Ehcache.
 * 
 * @author animesh.kumar
 */
public class EhCacheWrapper implements Cache
{

    /** The ehcache. */
    private net.sf.ehcache.Cache ehcache;

    /**
     * Instantiates a new eh cache wrapper.
     * 
     * @param ehcache
     *            the ehcache
     */
    public EhCacheWrapper(net.sf.ehcache.Cache ehcache)
    {
        this.ehcache = ehcache;
    }

    /* @see com.impetus.kundera.cache.Cache#get(java.lang.Object) */
    /*
     * (non-Javadoc)
     * 
     * @see com.impetus.kundera.cache.Cache#get(java.lang.Object)
     */
    @Override
    public Object get(Object key)
    {
        Element element = null;
        if(isAlive())
        {
            element = ehcache.get(key);
        }
        return element == null ? null : element.getObjectValue();
    }

    /*
     * @see com.impetus.kundera.cache.Cache#put(java.lang.Object,
     * java.lang.Object)
     */
    /*
     * (non-Javadoc)
     * 
     * @see com.impetus.kundera.cache.Cache#put(java.lang.Object,
     * java.lang.Object)
     */
    @Override
    public void put(Object key, Object value)
    {
        if(isAlive())
        ehcache.put(new Element(key, value));
    }

    /* @see com.impetus.kundera.cache.Cache#size() */
    /*
     * (non-Javadoc)
     * 
     * @see com.impetus.kundera.cache.Cache#size()
     */
    @Override
    public int size()
    {
        if(isAlive())
        {
            return ehcache.getSize();
        }
        return 0;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.persistence.Cache#contains(java.lang.Class, java.lang.Object)
     */
    @Override
    public boolean contains(Class arg0, Object arg1)
    {
        if(isAlive())
        {
            return (ehcache.get(arg1) != null);
        }
        
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.persistence.Cache#evict(java.lang.Class)
     */
    @Override
    public void evict(Class arg0)
    {
        // TODO Can we use Class with ehcache
        throw new NotImplementedException("TODO");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.persistence.Cache#evict(java.lang.Class, java.lang.Object)
     */
    @Override
    public void evict(Class arg0, Object arg1)
    {
        // TODO Can we use Class with ehcache
        if(isAlive())
        ehcache.remove(arg1);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.persistence.Cache#evictAll()
     */
    @Override
    public void evictAll()
    {
        if(isAlive())
        {
            ehcache.removeAll();
        }
    }

    private boolean isAlive()
    {
        return ehcache.getStatus().equals(Status.STATUS_ALIVE);
    }

}
