/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.dao.utils;

import com.impetus.kundera.KunderaException;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(JsonUtil.class);

    public static final <T> T readJson(String json, Class<T> clazz) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            if (json != null && !json.isEmpty()) {
                return (T)mapper.readValue(json, clazz);
            }
            LOGGER.error("JSON is null or empty.");
            throw new KunderaException("JSON is null or empty.");
        }
        catch (IOException e) {
            LOGGER.error("Error while converting in json{} presentation{}.", (Object)json, (Object)e);
            throw new KunderaException("Error while mapping JSON to Object. Caused By: ", (Throwable)e);
        }
    }

    public static final <T> T readJson(InputStream jsonStream, Class<T> clazz) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            if (jsonStream != null) {
                return (T)mapper.readValue(jsonStream, clazz);
            }
            LOGGER.error("InputStream is null.");
            throw new KunderaException("InputStream is null.");
        }
        catch (IOException e) {
            LOGGER.error("Error while mapping input stream to object. Caused By: ", (Throwable)e);
            throw new KunderaException("Error while mapping input stream to object. Caused By: ", (Throwable)e);
        }
    }
}

