/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core.language.searchcriteria;

import com.imperva.ddc.core.language.searchcriteria.SearchCriteria;
import com.imperva.ddc.core.language.searchcriteria.SearchCriteriaBuilder;
import com.imperva.ddc.core.query.Field;
import com.imperva.ddc.core.query.FieldInfo;
import com.imperva.ddc.core.query.SortKey;
import java.util.List;

public class ActiveDirectorySearchCriteriaBuilderImpl
extends SearchCriteriaBuilder {
    private List<Field> translatedRequestedFields;
    private List<SortKey> translatedRequestedSortKeys;
    private String searchFilter;

    @Override
    public void translateFields() {
        List<Field> fields = this.getQueryRequest().getRequestedFields();
        for (Field field : fields) {
            this.translateField(field);
        }
        this.translatedRequestedFields = fields;
    }

    @Override
    public void translateSortKeys() {
        List<SortKey> sortKeys = this.getQueryRequest().getSortKeys();
        for (SortKey sortKey : sortKeys) {
            this.translateField(sortKey);
        }
        this.translatedRequestedSortKeys = sortKeys;
    }

    @Override
    public void translateFilter() {
        String searchTest = this.getQueryRequest().getSearchText();
        if (searchTest != null && !searchTest.isEmpty()) {
            this.searchFilter = searchTest;
            return;
        }
        this.searchFilter = this.translateFilter(this.getQueryRequest().getSearchSentence());
    }

    @Override
    public String translateField(FieldInfo field) {
        String result;
        if (field.getType() == null) {
            return field.getName();
        }
        switch (field.getType()) {
            case GROUP_RECURSIVE: {
                result = "member:1.2.840.113556.1.4.1941:";
                break;
            }
            case GROUP_MEMBER_OF_RECURSIVE: {
                result = "memberof:1.2.840.113556.1.4.1941:";
                break;
            }
            case USER_ACCOUNT_CONTROL_FILTER: {
                result = "UserAccountControl:1.2.840.113556.1.4.803:";
                break;
            }
            default: {
                result = super.translateField(field);
            }
        }
        field.setName(result);
        return result;
    }

    @Override
    public SearchCriteria get() {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setSearchFilter(this.searchFilter);
        searchCriteria.setRequestedFields(this.translatedRequestedFields);
        searchCriteria.setRequestedSortKeys(this.translatedRequestedSortKeys);
        return searchCriteria;
    }
}

