/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core.language;

import com.imperva.ddc.core.language.Phrase;
import com.imperva.ddc.core.language.PhraseOperator;
import com.imperva.ddc.core.language.Sentence;
import com.imperva.ddc.core.language.SentenceOperator;
import com.imperva.ddc.core.language.Word;
import com.imperva.ddc.core.query.Field;
import com.imperva.ddc.core.query.FieldType;
import java.util.ArrayList;
import java.util.List;

public class QueryAssembler {
    private List<Word> searchPhrases = new ArrayList<Word>();

    public QueryAssembler addPhrase(FieldType fieldType, PhraseOperator phraseOperator, String value) {
        Phrase phrase = new Phrase();
        phrase.setValue(value);
        phrase.setPhraseOperator(phraseOperator);
        this.addPhrase(fieldType, phrase);
        return this;
    }

    public QueryAssembler addPhrase(String fieldName, PhraseOperator phraseOperator, String value) {
        Phrase phrase = new Phrase();
        phrase.setValue(value);
        phrase.setPhraseOperator(phraseOperator);
        this.addPhrase(fieldName, phrase);
        return this;
    }

    public QueryAssembler addPhrase(FieldType fieldType, Phrase phrase) {
        Field field = new Field();
        field.setType(fieldType);
        phrase.setAttribute(field);
        this.searchPhrases.add(phrase);
        return this;
    }

    public QueryAssembler addPhrase(String fieldName, Phrase phrase) {
        Field field = new Field();
        field.setName(fieldName);
        phrase.setAttribute(field);
        this.searchPhrases.add(phrase);
        return this;
    }

    public QueryAssembler addSentence(Sentence sentence) {
        this.searchPhrases.add(sentence);
        return this;
    }

    public Sentence closeSentence(SentenceOperator sentenceOperator) {
        Sentence sentence = this.makeSentence(this.searchPhrases, sentenceOperator);
        this.searchPhrases = new ArrayList<Word>();
        return sentence;
    }

    public Sentence closeSentence() {
        Sentence sentence = this.makeSentence(this.searchPhrases, SentenceOperator.EMPTY);
        this.searchPhrases = new ArrayList<Word>();
        return sentence;
    }

    private Sentence makeSentence(List<Word> phrases, SentenceOperator sentenceOperator) {
        Sentence sentence = new Sentence();
        sentence.setOperator(sentenceOperator);
        sentence.setSentences(phrases);
        return sentence;
    }

    public Sentence appendSentence(Sentence newSentence, Sentence currentSentence) {
        Sentence newAssembledSentence = null;
        if (newSentence != null && currentSentence != null) {
            newAssembledSentence = this.addSentence(newSentence).addSentence(currentSentence).closeSentence(SentenceOperator.AND);
        } else if (newSentence != null && currentSentence == null) {
            newAssembledSentence = newSentence;
        } else if (newSentence == null && currentSentence != null) {
            newAssembledSentence = currentSentence;
        }
        return newAssembledSentence;
    }
}

