/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core;

import com.imperva.ddc.core.QueryRequestExecutor;
import com.imperva.ddc.core.commons.Utils;
import com.imperva.ddc.core.exceptions.BaseException;
import com.imperva.ddc.core.query.DestinationType;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.LdapConnectionResult;
import com.imperva.ddc.core.query.Oops;
import com.imperva.ddc.core.query.PartitionResponse;
import com.imperva.ddc.core.query.QueryRequest;
import com.imperva.ddc.core.query.QueryResponse;
import com.imperva.ddc.core.query.RoundtripResult;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryRequestNonPagedExecutor
extends QueryRequestExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)QueryRequestNonPagedExecutor.class.getName());

    QueryRequestNonPagedExecutor(QueryRequest queryRequest) {
        super(queryRequest);
    }

    @Override
    QueryResponse execute() {
        QueryResponse response = new QueryResponse();
        ArrayList<PartitionResponse> result = new ArrayList<PartitionResponse>();
        for (Endpoint endpoint : this.queryRequest.getEndpoints()) {
            String host = endpoint.getHost();
            try {
                LOGGER.debug("Executing request for: " + host);
                PartitionResponse partitionResponse = new PartitionResponse();
                result.add(partitionResponse);
                partitionResponse.setEndpoint(endpoint);
                LdapConnectionResult ldapConnectionResult = this.driverGetInstance().connect(endpoint);
                String baseSearchPath = this.tryResolveBasePath(ldapConnectionResult.getConnection(), endpoint.getBaseSearchPath());
                endpoint.setBaseSearchPath(baseSearchPath);
                endpoint.setDestinationType(ldapConnectionResult.getDestinationType());
                endpoint.setBaseSearchPath(baseSearchPath);
                partitionResponse.setStatus(ldapConnectionResult.getStatuses());
                RoundtripResult roundtripResult = this.query(ldapConnectionResult.getConnection(), baseSearchPath);
                if (roundtripResult != null && roundtripResult.getData() != null) {
                    partitionResponse.setData(this.parserGetInstance().toEntityResponse(roundtripResult.getData(), this.queryRequest.getRequestedFields()));
                }
            }
            catch (BaseException | LdapException e) {
                LOGGER.error("Query Execution failed for Endpoint: " + host, e);
                ((PartitionResponse)result.get(result.size() - 1)).addStatus(host, new Oops((Exception)e));
                if (!Utils.isEmpty(endpoint.getSecondaryHost())) {
                    ((PartitionResponse)result.get(result.size() - 1)).addStatus(endpoint.getSecondaryHost(), new Oops((Exception)e));
                }
                endpoint.setDestinationType(DestinationType.NONE);
            }
            LOGGER.debug(result.size() + " results found for: " + host);
        }
        response.addPartitionResponse(result);
        return response;
    }

    RoundtripResult query(LdapConnection ldapConnection, String baseSearchPath) throws LdapException {
        if (ldapConnection != null && ldapConnection.isConnected()) {
            LdapConnection connection = ldapConnection;
            SearchRequest search = this.parserGetInstance().toSearchRequest(this.queryRequest, baseSearchPath);
            RoundtripResult roundtripResult = this.collectData(connection, search);
            return roundtripResult;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RoundtripResult collectData(LdapConnection connection, SearchRequest search) {
        RoundtripResult roundtripResult = new RoundtripResult();
        SearchCursor cursor = null;
        ArrayList<Entry> result = new ArrayList();
        try {
            cursor = connection.search(search);
            result = this.run(cursor);
            roundtripResult.setData(result);
        }
        catch (LdapException e) {
            LOGGER.error("Can't execute non-paged LDAP query", (Object[])e.getStackTrace());
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (IOException e) {
                    LOGGER.error("Can't close cursor", (Object[])e.getStackTrace());
                }
            }
        }
        LOGGER.trace("Collect Data. Data size:", result == null ? "NaN" : Integer.valueOf(result.size()));
        return roundtripResult;
    }
}

