/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core;

import com.imperva.ddc.core.exceptions.ProtocolException;
import com.imperva.ddc.core.query.EntityResponse;
import com.imperva.ddc.core.query.Field;
import com.imperva.ddc.core.query.ModificationDetails;
import com.imperva.ddc.core.query.Operation;
import com.imperva.ddc.core.query.QueryRequest;
import com.imperva.ddc.core.query.ReferralsHandling;
import com.imperva.ddc.core.query.SortKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.controls.PagedResultsImpl;
import org.apache.directory.api.ldap.model.message.controls.SortRequestControlImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApacheAPIConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ApacheAPIConverter.class.getName());

    ApacheAPIConverter() {
    }

    String[] toStringArray(List<Field> entities) {
        if (entities == null || entities.isEmpty()) {
            String[] result = new String[]{"*"};
            return result;
        }
        String[] result = new String[entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            result[i] = entities.get(i).getName();
        }
        return result;
    }

    public Modification toModification(ModificationDetails modificationDetails) {
        String value = null == modificationDetails.getValue() ? null : modificationDetails.getValue().toString();
        Operation operation = modificationDetails.getOperation();
        String strAttribute = modificationDetails.getAttribute().getName();
        switch (operation) {
            case ADD: {
                return new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, strAttribute, new String[]{value});
            }
            case REMOVE: {
                return null == value ? new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, strAttribute) : new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, strAttribute, new String[]{value});
            }
            case REPLACE: {
                return new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, strAttribute, new String[]{value});
            }
        }
        return null;
    }

    List<EntityResponse> toEntityResponse(List<Entry> entries, List<Field> requestedFields) {
        ArrayList<EntityResponse> entResponses = new ArrayList<EntityResponse>();
        for (Entry ent : entries) {
            EntityResponse entResponse = new EntityResponse();
            entResponse.setKey(ent.getDn().getName());
            for (Attribute att : ent.getAttributes()) {
                for (Field field : requestedFields) {
                    if (!field.getName().equals("*") && !field.getName().equalsIgnoreCase(att.getId())) continue;
                    att.iterator().forEachRemaining(value -> entResponse.addValue(value.getValue(), att.getId(), field.getType()));
                }
            }
            entResponses.add(entResponse);
        }
        return entResponses;
    }

    SearchRequest toSearchRequest(QueryRequest queryRequest, String baseSearchPath) throws LdapException {
        List<SortKey> sortKeys;
        String searchText;
        SearchRequestImpl search = new SearchRequestImpl();
        search.setScope(SearchScope.SUBTREE);
        String[] translatedRequestedFieldsArray = this.toStringArray(queryRequest.getRequestedFields());
        search.addAttributes(translatedRequestedFieldsArray);
        search.setTimeLimit(queryRequest.getTimeLimit().intValue());
        search.setSizeLimit((long)queryRequest.getSizeLimit().intValue());
        search.setBase(new Dn(new String[]{baseSearchPath}));
        if (queryRequest.getReferralsHandling() == ReferralsHandling.FOLLOW) {
            search.followReferrals();
        } else if (queryRequest.getReferralsHandling() == ReferralsHandling.IGNORE) {
            search.ignoreReferrals();
        }
        String string = searchText = queryRequest.getSearchText() == null ? queryRequest.getSearchSentenceText() : queryRequest.getSearchText();
        if (searchText != null && !searchText.trim().isEmpty()) {
            search.setFilter(searchText);
        }
        if (!Objects.isNull(sortKeys = queryRequest.getSortKeys()) && !sortKeys.isEmpty()) {
            SortRequestControlImpl sortRequest = this.applySort(sortKeys);
            search.addControl((Control)sortRequest);
        }
        return search;
    }

    SearchRequest toSearchRequest(QueryRequest queryRequest, String baseSearchPath, Object cookie) throws LdapException {
        SearchRequest search = this.toSearchRequest(queryRequest, baseSearchPath);
        if (queryRequest.isPaged()) {
            PagedResultsImpl pagedSearchControl = new PagedResultsImpl();
            int size = queryRequest.getPageChunkSize();
            pagedSearchControl.setSize(size);
            pagedSearchControl.setCookie((byte[])cookie);
            pagedSearchControl.setCritical(true);
            search.addControl((Control)pagedSearchControl);
        }
        return search;
    }

    SortRequestControlImpl applySort(List<SortKey> sortKeys) {
        if (Objects.isNull(sortKeys) && sortKeys.isEmpty()) {
            throw new ProtocolException("Sorting keys can't be empty");
        }
        SortRequestControlImpl sortRequest = new SortRequestControlImpl();
        sortRequest.setCritical(false);
        for (SortKey sortKey : sortKeys) {
            sortRequest.addSortKey(new org.apache.directory.api.ldap.model.message.controls.SortKey(sortKey.getName(), sortKey.getMatchingRuleId(), sortKey.isReverseOrder()));
        }
        return sortRequest;
    }
}

