/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core;

import com.imperva.ddc.core.Driver;
import com.imperva.ddc.core.DriverBase;
import com.imperva.ddc.core.DriverHostResolverDecorator;
import com.imperva.ddc.core.DriverRobustDecorator;
import com.imperva.ddc.core.exceptions.AddRequestFailedException;
import com.imperva.ddc.core.exceptions.BaseException;
import com.imperva.ddc.core.query.AddRequest;
import com.imperva.ddc.core.query.DestinationType;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.Field;
import com.imperva.ddc.core.query.LdapConnectionResult;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRequestExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AddRequestExecutor.class.getName());
    AddRequest addRequest;

    public AddRequestExecutor(AddRequest addRequest) {
        this.addRequest = addRequest;
    }

    void execute() {
        Endpoint endpoint = this.addRequest.getEndpoint();
        String host = endpoint.getHost();
        try {
            LOGGER.debug("Executing request for: " + host);
            LdapConnectionResult ldapConnectionResult = this.driverGetInstance().connect(endpoint);
            DefaultEntry entry = new DefaultEntry();
            entry.setDn(this.addRequest.getDn());
            for (Field f : this.addRequest.getFields()) {
                entry.add(f.getName(), new String[]{f.getValue().toString()});
            }
            ldapConnectionResult.getConnection().add((Entry)entry);
        }
        catch (BaseException | LdapException e) {
            LOGGER.error("Add Execution failed for Endpoint: " + host, e);
            endpoint.setDestinationType(DestinationType.NONE);
            throw new AddRequestFailedException(e.getMessage(), host);
        }
    }

    DriverBase driverGetInstance() {
        return new DriverHostResolverDecorator(new DriverRobustDecorator(new Driver()));
    }
}

