
package com.ig.orchestrations.fixp;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum FlowType {

    RECOVERABLE("Recoverable"),
    UNSEQUENCED("Unsequenced"),
    IDEMPOTENT("Idempotent"),
    NONE("None");
    private final String value;
    private final static Map<String, FlowType> CONSTANTS = new HashMap<String, FlowType>();

    static {
        for (FlowType c: values()) {
            CONSTANTS.put(c.value, c);
        }
    }

    private FlowType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static FlowType fromValue(String value) {
        FlowType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        } else {
            return constant;
        }
    }

}
