/*
 * Decompiled with CFR 0.152.
 */
package com.ifttt;

import android.support.annotation.NonNull;
import com.ifttt.ApiPendingResult;
import com.ifttt.Applet;
import com.ifttt.AppletJsonAdapter;
import com.ifttt.AppletListJsonAdapter;
import com.ifttt.ErrorResponse;
import com.ifttt.HexColorJsonAdapter;
import com.ifttt.InviteCodeInterceptor;
import com.ifttt.RetrofitAppletConfigApi;
import com.ifttt.RetrofitAppletsApi;
import com.ifttt.RetrofitUserApi;
import com.ifttt.SdkInfoInterceptor;
import com.ifttt.TokenInterceptor;
import com.ifttt.User;
import com.ifttt.api.AppletConfigApi;
import com.ifttt.api.AppletsApi;
import com.ifttt.api.PendingResult;
import com.ifttt.api.UserApi;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Rfc3339DateJsonAdapter;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

public final class IftttApiClient {
    static final String ANONYMOUS_ID = UUID.randomUUID().toString();
    private static IftttApiClient INSTANCE;
    private final TokenInterceptor tokenInterceptor;
    private final InviteCodeInterceptor inviteCodeInterceptor;
    private final AppletsApi appletsApi;
    private final AppletConfigApi appletConfigApi;
    private final UserApi userApi;

    private IftttApiClient() {
        Moshi moshi = new Moshi.Builder().add((Object)new HexColorJsonAdapter()).add(Date.class, new Rfc3339DateJsonAdapter().nullSafe()).add((Object)new AppletJsonAdapter()).add((Object)new AppletListJsonAdapter()).build();
        JsonAdapter errorResponseJsonAdapter = moshi.adapter(ErrorResponse.class);
        this.tokenInterceptor = new TokenInterceptor();
        this.inviteCodeInterceptor = new InviteCodeInterceptor();
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)this.tokenInterceptor).addInterceptor((Interceptor)this.inviteCodeInterceptor).addInterceptor((Interceptor)new SdkInfoInterceptor()).build();
        Retrofit retrofit = new Retrofit.Builder().addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)moshi)).baseUrl("https://api.ifttt.com").client(okHttpClient).build();
        RetrofitAppletConfigApi retrofitAppletConfigApi = (RetrofitAppletConfigApi)retrofit.create(RetrofitAppletConfigApi.class);
        this.appletConfigApi = new InternalAppletConfigApi(retrofitAppletConfigApi, (JsonAdapter<ErrorResponse>)errorResponseJsonAdapter);
        RetrofitAppletsApi retrofitAppletsApi = (RetrofitAppletsApi)retrofit.create(RetrofitAppletsApi.class);
        this.appletsApi = new InternalAppletsApi(retrofitAppletsApi, (JsonAdapter<ErrorResponse>)errorResponseJsonAdapter);
        RetrofitUserApi retrofitUserApi = (RetrofitUserApi)retrofit.create(RetrofitUserApi.class);
        this.userApi = new InternalUserApi(retrofitUserApi, (JsonAdapter<ErrorResponse>)errorResponseJsonAdapter);
    }

    public AppletConfigApi appletConfigApi() {
        return this.appletConfigApi;
    }

    public AppletsApi appletsApi() {
        return this.appletsApi;
    }

    public UserApi userApi() {
        return this.userApi;
    }

    public void setUserToken(@NonNull String userToken) {
        this.tokenInterceptor.setToken(userToken);
    }

    public void clearUserToken() {
        this.tokenInterceptor.setToken(null);
    }

    public void setInviteCode(@NonNull String inviteCode) {
        this.inviteCodeInterceptor.setInviteCode(inviteCode);
    }

    public void clearInviteCode() {
        this.inviteCodeInterceptor.setInviteCode(null);
    }

    public static IftttApiClient getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IftttApiClient();
        }
        return INSTANCE;
    }

    private static final class InternalUserApi
    implements UserApi {
        private final RetrofitUserApi retrofitUserApi;
        private final JsonAdapter<ErrorResponse> errorResponseJsonAdapter;

        InternalUserApi(RetrofitUserApi retrofitUserApi, JsonAdapter<ErrorResponse> errorResponseJsonAdapter) {
            this.retrofitUserApi = retrofitUserApi;
            this.errorResponseJsonAdapter = errorResponseJsonAdapter;
        }

        @Override
        public PendingResult<User> user() {
            return new ApiPendingResult<User>(this.retrofitUserApi.user(), this.errorResponseJsonAdapter);
        }
    }

    private static final class InternalAppletConfigApi
    implements AppletConfigApi {
        private final RetrofitAppletConfigApi retrofitAppletConfigApi;
        private final JsonAdapter<ErrorResponse> errorResponseJsonAdapter;

        InternalAppletConfigApi(RetrofitAppletConfigApi retrofitAppletConfigApi, JsonAdapter<ErrorResponse> errorResponseJsonAdapter) {
            this.retrofitAppletConfigApi = retrofitAppletConfigApi;
            this.errorResponseJsonAdapter = errorResponseJsonAdapter;
        }

        @Override
        public PendingResult<Applet> enableApplet(String serviceId, String appletId) {
            return new ApiPendingResult<Applet>(this.retrofitAppletConfigApi.enableApplet(serviceId, appletId), this.errorResponseJsonAdapter);
        }

        @Override
        public PendingResult<Applet> disableApplet(String serviceId, String appletId) {
            return new ApiPendingResult<Applet>(this.retrofitAppletConfigApi.disableApplet(serviceId, appletId), this.errorResponseJsonAdapter);
        }
    }

    private static final class InternalAppletsApi
    implements AppletsApi {
        private final RetrofitAppletsApi retrofitAppletsApi;
        private final JsonAdapter<ErrorResponse> errorResponseJsonAdapter;

        InternalAppletsApi(RetrofitAppletsApi retrofitAppletsApi, JsonAdapter<ErrorResponse> errorResponseJsonAdapter) {
            this.retrofitAppletsApi = retrofitAppletsApi;
            this.errorResponseJsonAdapter = errorResponseJsonAdapter;
        }

        @Override
        public PendingResult<List<Applet>> listApplets(String serviceId, AppletsApi.Platform platform, AppletsApi.Order order) {
            return new ApiPendingResult<List<Applet>>(this.retrofitAppletsApi.listApplets(serviceId, platform, order), this.errorResponseJsonAdapter);
        }

        @Override
        public PendingResult<Applet> showApplet(String serviceId, String appletId) {
            return new ApiPendingResult<Applet>(this.retrofitAppletsApi.showApplet(serviceId, appletId), this.errorResponseJsonAdapter);
        }
    }
}

