/*
 * Decompiled with CFR 0.152.
 */
package com.ifttt;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ifttt.IftttApiClient;
import com.ifttt.Service;
import java.util.Date;
import java.util.List;

public final class Applet
implements Parcelable {
    public final String id;
    public final String name;
    public final String description;
    public final Status status;
    @Nullable
    public final Date publishedAt;
    public final int enabledCount;
    @Nullable
    public final Date lastRunAt;
    public final String url;
    public final List<Service> services;
    private final String embeddedUrl;
    private Service primaryService;
    public static final Parcelable.Creator<Applet> CREATOR = new Parcelable.Creator<Applet>(){

        public Applet createFromParcel(Parcel in) {
            return new Applet(in);
        }

        public Applet[] newArray(int size) {
            return new Applet[size];
        }
    };

    public Applet(String id, String name, String description, Status status, @Nullable Date publishedAt, int enabledCount, @Nullable Date lastRunAt, String url, String embeddedUrl, List<Service> services) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.status = status;
        this.publishedAt = publishedAt;
        this.enabledCount = enabledCount;
        this.lastRunAt = lastRunAt;
        this.url = url;
        this.embeddedUrl = embeddedUrl;
        this.services = services;
    }

    public Service getPrimaryService() {
        if (this.primaryService == null) {
            for (Service service : this.services) {
                if (!service.isPrimary) continue;
                this.primaryService = service;
                break;
            }
        }
        if (this.primaryService == null) {
            throw new AssertionError((Object)"Primary service should not be null.");
        }
        return this.primaryService;
    }

    @CheckResult
    public Uri getEmbedUri(@NonNull String redirectUri, @NonNull String userId, @Nullable String email, @Nullable String inviteCode) {
        Uri.Builder builder = Uri.parse((String)this.embeddedUrl).buildUpon().appendQueryParameter("user_id", userId).appendQueryParameter("redirect_uri", redirectUri).appendQueryParameter("ifttt_sdk_version", "0.0.1").appendQueryParameter("ifttt_sdk_platform", "android").appendQueryParameter("ifttt_sdk_anonymous_id", IftttApiClient.ANONYMOUS_ID);
        if (email != null) {
            builder.appendQueryParameter("email", email);
        }
        if (inviteCode != null) {
            builder.appendQueryParameter("invite_code", inviteCode);
        }
        return builder.build();
    }

    protected Applet(Parcel in) {
        this.id = in.readString();
        this.name = in.readString();
        this.description = in.readString();
        this.status = Status.valueOf(in.readString());
        long publishedAtTimestamp = in.readLong();
        this.publishedAt = publishedAtTimestamp < 0L ? null : new Date(publishedAtTimestamp);
        this.enabledCount = in.readInt();
        long lastRunAtTimestamp = in.readLong();
        this.lastRunAt = lastRunAtTimestamp < 0L ? null : new Date(lastRunAtTimestamp);
        this.url = in.readString();
        this.embeddedUrl = in.readString();
        this.services = in.createTypedArrayList(Service.CREATOR);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.id);
        parcel.writeString(this.name);
        parcel.writeString(this.description);
        parcel.writeString(this.status.name());
        parcel.writeLong(this.publishedAt != null ? this.publishedAt.getTime() : -1L);
        parcel.writeInt(this.enabledCount);
        parcel.writeLong(this.lastRunAt != null ? this.lastRunAt.getTime() : -1L);
        parcel.writeString(this.url);
        parcel.writeString(this.embeddedUrl);
        parcel.writeTypedList(this.services);
    }

    public static enum Status {
        enabled,
        disabled,
        never_enabled,
        unknown;

    }
}

