package com.ideabus.ideabuslibrary.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * Created by GuanYu on 2016/8/14.
 */
public class TimeUtils {

    /**
     * 取得當下時間
     * "yyyy-MM-dd hh:mm:ss"
     * "yyyy-MM"
     *
     * @param format
     * @return
     */
    public static String getCurrentTime(String format) {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());

        return simpleDateFormat.format(date);
    }

    /**
     * 比較時間
     * @param date1
     * @param date2
     * @param  "yyyy-MM-dd HH:mm:ss"
     * @return 1：代表 date1 大於 date2;
     * -1：代表 date2 大於 date1;
     */
    public static int compareDate(String date1, String date2, String format) {
        DateFormat dateFormat = new SimpleDateFormat(format, Locale.getDefault());

        try {
            Date dt1 = dateFormat.parse(date1);
            Date dt2 = dateFormat.parse(date2);

            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            } else if (dt1.getTime() < dt2.getTime()) {
                return -1;
            } else {
                return 0;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }
}
