package com.ideabus.ideabuslibrary.util;

import android.text.TextUtils;

import java.util.regex.Pattern;

/**
 * Created by GuanYu on 2016/8/14.
 */
public class RegularUtils {

    //驗證信箱
    private static final String REGEX_EMAIL = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";

    //驗證只能有英文和數字，範圍6~12
    private static final String REGEX_PASSWORD = "^(?!.*[^a-zA-Z0-9])(?=.*\\d)(?=.*[a-zA-Z]).{6,12}$";

    public static boolean isMatch(String regex, String string) {
        return !TextUtils.isEmpty(string) && Pattern.matches(regex, string);
    }

    public static boolean isEmail(String email) {
        return isMatch(REGEX_EMAIL, email);
    }

    public static boolean isPassword(String password) {
        return isMatch(REGEX_PASSWORD, password);
    }
}
