package com.ideabus.ideabuslibrary.bluetooth;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;

import java.util.ArrayList;
import java.util.List;

public class BluetoothLEClass {
	
	/**
     * bluetooth connect state callback.
     */
	public static final int CALLBACK_STATE = 0x01;
	/**
     * bluetooth communications result.
     */
	public static final int CALLBACK_RESULT = 0x02;
	/**
     * bluetooth scan success.
     */
	public static final int SCAN_RESULT = 0x03;
	/**
	 * bluetooth scan finish.
	 */
	public static final int SCAN_FINISH = 0x04;
	public static final int SCAN_STOP = 0x05;
	public static final int SCAN_LOOP = 0x06;
	
	/**
	 * none.
	 */
	public static final int NONE = 0x010;
	/**
	 * connected.
	 */
	public static final int CONNECTED = 0x11;
	/**
	 * disconnected.
	 */
	public static final int DISCONNECTED = 0x12;
	/**
	 * unspecified address.
	 */
	@Deprecated
	public static final int UNSPECIFIED_ADDRESS = 0x13;
	/**
	 * connect timeout.
	 */
	public static final int CONNECT_TIMEOUT = 0x14;
	/**
	 * connecting.
	 */
	public static final int CONNECTING = 0x15;
	/**
	 * command timeout.
	 */
//	public static final int COMMAND_TIMEOUT = 0x16;
	/**
	 * command received error.
	 */
//	public static final int RECEIVED_ERROR = 0x0C;
	public static final int ERROR133_RESTART_BT = 0x17;
	
	
	/**
	 * 開啟藍芽startActivityResult Code
	 */
	public static final int ACTION_REQUEST_ENABLE = 100;
	/**
	 * 掃描時間TimeOut
	 */
//	public static final int SCAN_PERIOD = 10000;
	/**
	 * 連線時間TimeOut
	 */
	public static final int CONNECT_PERIOD = 15000;
	
	/**
	 * BluetoothGatt 操作類
	 */
	private List<BluetoothGatt> mBluetoothGatts;
	/**
	 * protocol command array
	 */
	private List<String> commArray;
	/**
	 * BluetoothGattCharacteristic 操作類
	 */
	public List<BluetoothGattCharacteristic> charWriteList;
	/**
	 * 紀錄notify數量，與connGattCount比對判斷是否全部搜尋到
	 */
	public int charNotifyCount = 0;
	/**
	 * 共有幾組藍牙需要連線
	 */
	public int connGattCount = 0;
	/**
	 * 發送10次後如果沒收到回傳值時 comm timeout
	 */
//	public int sendCount = 0;
	/**
	 * 與connGattCount比對判斷是否全部讀取到
	 */
//	public int notifyCound = 0;
	/**
	 * write thread flag
	 */
	public boolean isWriteRunning = false;
	
	public void initBluetoothGattsArray(){
		mBluetoothGatts = new ArrayList<BluetoothGatt>();
	}
	
	public void addBluetoothGatt(BluetoothGatt gatt){
		if(mBluetoothGatts != null)
			mBluetoothGatts.add(gatt);
	}
	
	public BluetoothGatt getBluetoothGatt(int i){
		if(mBluetoothGatts != null && mBluetoothGatts.size() > i)
			return mBluetoothGatts.get(i);
		else
			return null;
	}
	
	public List<BluetoothGatt> getBluetoothGatts(){
		return mBluetoothGatts;
	}
	
	public void removeBluetoothGatt(){
		if(mBluetoothGatts != null && mBluetoothGatts.size() > 0)
			mBluetoothGatts.remove(0);
	}
	
	public void initCommArray(){
		commArray = new ArrayList<String>();
	}
	
	public void addCommArray(String comm){
		if(commArray != null)
			commArray.add(comm);
	}
	
	public String getComm(int i){
		if(commArray != null && commArray.size() > i)
			return commArray.get(i);
		else
			return null;
	}
	
	public int getCommArraySize(){
		return commArray == null ? 0 : commArray.size();
	}
	
	public void removeComm(int i){
		if(commArray != null && commArray.size() > i)
			commArray.remove(i);
	}
	
	public void removeSameComm(String cmd){
		if(commArray == null)
			return;
		for(int i = 0 ; i < commArray.size() ; i++){
			if(commArray.get(i).equals(cmd))
				commArray.remove(i);
		}
	}
	
	/**
	 * 只留前2筆資料，不然如果剛好有comm再通訊時，commArray第0個會被remove掉
	 */
	public void removeOtherComm(){
		if(commArray != null && commArray.size() > 1){
			String str = commArray.get(0);
			commArray.clear();
			commArray.add(str);
		}
	}
	
	public void removeAllComm(){
		if(commArray != null)
			commArray.clear();
	}
	
	//---------------回調事件----------------------------------------------------
	public int mCurrentStatus = NONE;
	
	public interface OnIMBluetoothLEListener {
		/**
		 * BLE狀態改變事件
		 * @param isOpen 
		 */
		void onBtStateChanged(boolean isOpen);
		/**
		 * 返回掃描到的藍芽
		 * @param mac 藍牙 Mac Address
		 * @param name 藍牙名稱
		 * @param rssi 藍牙訊號
		 */
		void scanResult(String mac, String name, int rssi, byte[] scanRecord);
		/**
		 * 藍牙狀態 
		 * @param status 
		 * {@link BluetoothLEClass#SCAN_FINISH} ,
		 * {@link BluetoothLEClass#CONNECTED} ,
		 * {@link BluetoothLEClass#DISCONNECTED} ,
		 * {@link BluetoothLEClass#UNSPECIFIED_ADDRESS} ,
		 * {@link BluetoothLEClass#CONNECT_TIMEOUT}
		 */
		void connectionStatus(int status);
		/**
		 * BLE返回數據事件
		 * @param message
		 */
		void dataResult(String message);
	}
	public static OnIMBluetoothLEListener mOnIMBluetoothLEListener;
	public void setOnIMBluetoothLEListener(OnIMBluetoothLEListener l){
	    mOnIMBluetoothLEListener = l;
	}
	//---------------回調事件----------------------------------------------------
		
}
