/*
 * Decompiled with CFR 0.152.
 */
package com.ideabus.ideabuslibrary.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;

public class KeyboardUtils {
    public static void hideSoftInput(Context mContext, EditText editText) {
        editText.setFocusable(false);
        editText.setFocusableInTouchMode(false);
        InputMethodManager inputMethodManager = (InputMethodManager)mContext.getSystemService("input_method");
        inputMethodManager.hideSoftInputFromWindow(editText.getWindowToken(), 2);
    }

    public static void showSoftInput(Context mContext, EditText editText) {
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();
        InputMethodManager imm = (InputMethodManager)mContext.getSystemService("input_method");
        imm.showSoftInput((View)editText, 1);
    }

    public static void setBackHideSoft(Activity activity, final EditText editText) {
        final View rootView = activity.getWindow().getDecorView().findViewById(0x1020002);
        rootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                Rect r = new Rect();
                rootView.getWindowVisibleDisplayFrame(r);
                int screenHeight = rootView.getRootView().getHeight();
                int keypadHeight = screenHeight - r.bottom;
                if ((double)keypadHeight > (double)screenHeight * 0.2) {
                    editText.setFocusableInTouchMode(true);
                    editText.requestFocus();
                } else {
                    editText.setFocusable(false);
                }
            }
        });
    }
}

