/*
 * Decompiled with CFR 0.152.
 */
package com.ideabus.ideabuslibrary.util;

import android.content.ContentUris;
import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import java.io.IOException;
import java.io.InputStream;

public class FileUtil {
    public static String getAbsolutePath(Context context, Uri uri) {
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileUtil.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (FileUtil.isDownloadsDocument(uri)) {
                    String id = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id));
                    return FileUtil.getDataColumn(context, contentUri, null, null);
                }
                if (FileUtil.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return FileUtil.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                return FileUtil.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string = cursor.getString(column_index);
                return string;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static int getBitmapDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    public static Bitmap decodeBitmapFromRid(Resources resources, int rid, int inSampleSize) {
        if (rid == 0) {
            return null;
        }
        BitmapFactory.Options options = FileUtil.getBitmapOptions(inSampleSize);
        InputStream is = resources.openRawResource(rid);
        return BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
    }

    public static Bitmap decodeBitmapFromByteArray(byte[] byteArray, int inSampleSize) {
        if (byteArray == null) {
            return null;
        }
        BitmapFactory.Options options = FileUtil.getBitmapOptions(inSampleSize);
        return BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)options);
    }

    private static BitmapFactory.Options getBitmapOptions(int inSampleSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inSampleSize = inSampleSize;
        return options;
    }
}

