/*
 * Decompiled with CFR 0.152.
 */
package com.ideabus.ideabuslibrary.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.ideabus.ideabuslibrary.bluetooth.BluetoothLEClass;
import com.ideabus.ideabuslibrary.bluetooth.BluetoothLEUtils;

public class BluetoothLEHandler
extends Handler {
    private static final String TAG = BluetoothLEHandler.class.getSimpleName();
    private BluetoothLEUtils bluetooth;
    private BluetoothAdapter mBluetoothAdapter;
    private boolean isRun = false;

    public BluetoothLEHandler(BluetoothLEUtils bt, BluetoothAdapter adapter) {
        this.bluetooth = bt;
        this.mBluetoothAdapter = adapter;
    }

    public void handleMessage(Message message) {
        super.handleMessage(message);
        switch (message.what) {
            case 6: {
                if (!this.bluetooth.isScanning) {
                    return;
                }
                this.bluetooth.startLEScan(message.arg1, true);
                if (BluetoothLEClass.mOnIMBluetoothLEListener == null) break;
                BluetoothLEClass.mOnIMBluetoothLEListener.connectionStatus(4);
                break;
            }
            case 4: {
                this.bluetooth.isScanning = false;
                if (this.mBluetoothAdapter != null) {
                    this.mBluetoothAdapter.stopLeScan(this.bluetooth.setLeScanCallback());
                }
                if (BluetoothLEClass.mOnIMBluetoothLEListener == null) break;
                BluetoothLEClass.mOnIMBluetoothLEListener.connectionStatus(message.what);
                break;
            }
            case 21: {
                Log.i((String)TAG, (String)("\u6b63\u5728\u5275\u5efa \u7b2c " + message.arg1 + " \u9846\u85cd\u7259\u9023\u7dda"));
                this.bluetooth.mCurrentStatus = 21;
                this.bluetooth.addBluetoothGatt(((BluetoothDevice)message.obj).connectGatt(this.bluetooth.getContext(), false, this.bluetooth.setLeGattCallback()));
                break;
            }
            case 20: {
                if (this.bluetooth.mCurrentStatus == 17) break;
                Log.i((String)TAG, (String)"\u9023\u7dda\u8d85\u6642");
                this.bluetooth.disconnect(18);
                break;
            }
            case 3: {
                if (BluetoothLEClass.mOnIMBluetoothLEListener == null) break;
                Bundle bd = message.getData();
                BluetoothLEClass.mOnIMBluetoothLEListener.scanResult(bd.getString("address"), bd.getString("name"), bd.getInt("rssi"), bd.getByteArray("scanRecord"));
                break;
            }
            case 1: {
                if (BluetoothLEClass.mOnIMBluetoothLEListener != null) {
                    BluetoothLEClass.mOnIMBluetoothLEListener.connectionStatus(this.bluetooth.mCurrentStatus);
                }
                if (this.bluetooth.mCurrentStatus == 17 && !this.isRun) {
                    this.isRun = true;
                    this.bluetooth.onWriteThreadStart(this);
                    break;
                }
                this.isRun = false;
                break;
            }
            case 2: {
                if (BluetoothLEClass.mOnIMBluetoothLEListener == null) break;
                BluetoothLEClass.mOnIMBluetoothLEListener.dataResult((String)message.obj);
            }
        }
    }
}

