package com.ideabus.ideabuslibrary.util;

import android.os.Build;
import android.text.Html;
import android.util.Base64;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

/**
 * Created by GuanYu on 2016/8/14.
 */
public class EncodeUtils  {

    private EncodeUtils() {
        throw new UnsupportedOperationException("error");
    }


    /**
     * 編碼為UTF-8
     * @param input
     * @return
     */
    public static String urlEncode(String input) {
        return urlEncode(input, "UTF-8");
    }

    /**
     * 自定義編碼格式
     * @param input
     * @param charset
     * @return
     */
    public static String urlEncode(String input, String charset) {
        try {
            return URLEncoder.encode(input, charset);
        } catch (UnsupportedEncodingException e) {
            return input;
        }
    }

    /**
     * UTF-8解碼
     * @param input
     * @return
     */
    public static String urlDncode(String input){
        return urlDecode(input, "UTF-8");
    }

    /**
     * 自定義解碼格式
     * @param input
     * @param charset
     * @return
     */
    public static String urlDecode(String input, String charset) {
        try {
            return URLDecoder.decode(input, charset);
        } catch (UnsupportedEncodingException e) {
            return input;
        }
    }

    /**
     * Base64編碼
     * @param input
     * @return
     */
    public static String base64Encode(String input) {
        return base64Encode(input.getBytes());
    }

    /**
     * Base64編碼
     * @param input
     * @return
     */
    public static String base64Encode(byte[] input) {
        return Base64.encodeToString(input, Base64.DEFAULT);
    }

    /**
     * Base64解碼
     * @param input
     * @return
     */
    public static String base64Decode(String input) {
        return new String(Base64.decode(input, Base64.DEFAULT));
    }


}
