package com.ideabus.ideabuslibrary.util;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Window;
import android.view.WindowManager;

/**
 * Created by GuanYu on 2016/8/14.
 */
public class ScreenUtils {

    /**
     * 獲取螢幕寬度 px
     * @param mContext
     * @return
     */
    public static int getScreenWidth(Context mContext) {
        WindowManager windowManager = (WindowManager) mContext.getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    /**
     * 獲取螢幕長度 px
     * @param mContext
     * @return
     */
    public static int getScreenHeight(Context mContext) {
        WindowManager windowManager = (WindowManager) mContext.getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    /**
     * 設置全螢幕
     * @param mActivity
     */
    public static void SetFullScreen(Activity mActivity) {
        mActivity.requestWindowFeature(Window.FEATURE_NO_TITLE);
        mActivity.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,WindowManager.LayoutParams.FLAG_FULLSCREEN);
    }

    /**
     * 取得ActionBar高度
     * @param mActivity
     * @return
     */
    public static int getActionBarHeight(Activity mActivity) {
        TypedValue typedValue = new TypedValue();
        if (mActivity.getTheme().resolveAttribute(android.R.attr.actionBarSize, typedValue, true)) {
            return TypedValue.complexToDimensionPixelSize(typedValue.data, mActivity.getResources().getDisplayMetrics());
        }
        return 0;
    }
}
