/*
 * Decompiled with CFR 0.152.
 */
package com.ideabus.ideabuslibrary;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.support.v4.content.ContextCompat;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Patterns;
import android.widget.Toast;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Locale;

public class BaseGlobal {
    private static boolean isPrintLog = true;
    public static float density = 0.0f;
    public static int screenWidth = 0;
    public static int screenHeight = 0;
    public static float screenScale = 0.0f;
    public static boolean isTabletScaleSize;
    private static Toast toast;

    @Nullable
    public static Drawable ridToDrawable(Resources res, int resId) {
        BitmapDrawable bd = null;
        try {
            InputStream is = res.openRawResource(resId);
            bd = new BitmapDrawable(res, BitmapFactory.decodeStream((InputStream)is));
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            System.gc();
        }
        return bd;
    }

    public static boolean matcherEmail(String email) {
        return Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    public static int getColor(Context context, int id) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 23) {
            return ContextCompat.getColor((Context)context, (int)id);
        }
        return context.getResources().getColor(id);
    }

    public static String convertUtf8ToString(byte[] bytes) {
        String asd = "";
        try {
            asd = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return asd;
    }

    public static void showToast(Activity mActivity, String text) {
        if (toast == null) {
            toast = Toast.makeText((Context)mActivity, (CharSequence)text, (int)0);
        } else {
            toast.setText((CharSequence)text);
        }
        toast.show();
    }

    public static int convertStringToInt(String str) {
        return BaseGlobal.convertStringToInt(str, 10);
    }

    public static int convertStringToInt(String str, int radix) {
        int i = 0;
        try {
            i = Integer.parseInt(str, radix);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return i;
    }

    public static SharedPreferences getSharedPref(Context context, String sharedPrefName) {
        return context.getSharedPreferences(sharedPrefName, 0);
    }

    public static SharedPreferences.Editor getSharePrefEditor(Context context, String sharedPrefName) {
        return context.getSharedPreferences(sharedPrefName, 0).edit();
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        if (activeNetworkInfo == null || !activeNetworkInfo.isConnected()) {
            return false;
        }
        return activeNetworkInfo.isAvailable();
    }

    public static String getFillString(int i, int length, String fillStr) {
        StringBuilder str = new StringBuilder(String.valueOf(i));
        while (str.length() < length) {
            str.insert(0, fillStr);
        }
        return str.toString();
    }

    public static String getScaleToString(float value, int scale) {
        return BaseGlobal.getScaleDecimal(value, scale).toString();
    }

    public static float getScaleToFloat(float value, int scale) {
        return BaseGlobal.getScaleDecimal(value, scale).floatValue();
    }

    private static BigDecimal getScaleDecimal(float value, int scale) {
        return new BigDecimal(value).setScale(scale, RoundingMode.HALF_UP);
    }

    public static float divide(float value, float divideValue, int scale) {
        BigDecimal bigDecimal = new BigDecimal(value).divide(new BigDecimal(divideValue), scale, RoundingMode.HALF_UP);
        return bigDecimal.floatValue();
    }

    public static String getStringPlace(String num, int place) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumIntegerDigits(place);
        return nf.format(num);
    }

    public static String getStringPlace(int num, int place) {
        return BaseGlobal.getStringPlace(String.valueOf(num), place);
    }

    public static String getDateTime() {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        int minute = c.get(12);
        int second = c.get(13);
        String date = year + "/" + BaseGlobal.getStringPlace(month, 2) + "/" + BaseGlobal.getStringPlace(day, 2) + " " + BaseGlobal.getStringPlace(hour, 2) + ":" + BaseGlobal.getStringPlace(minute, 2) + ":" + BaseGlobal.getStringPlace(second, 2);
        return date;
    }

    public static float convertDpToPixel(float dp) {
        float px = dp * density;
        return px;
    }

    public static float convertPixelToDp(float pixel) {
        float dp = pixel / density;
        return dp;
    }

    public static void setIsPrintLog(boolean b) {
        isPrintLog = b;
    }

    public static void printLog(String type, String tag, String msg) {
        int priority = 0;
        if (type.equals("i")) {
            priority = 4;
        } else if (type.equals("d")) {
            priority = 3;
        } else if (type.equals("e")) {
            priority = 6;
        }
        if (isPrintLog) {
            Log.println((int)priority, (String)tag, (String)msg);
        }
    }

    public static void setAppLocale(Resources resources, Locale locale) {
        Configuration config = resources.getConfiguration();
        DisplayMetrics dm = resources.getDisplayMetrics();
        config.setLocale(locale);
        resources.updateConfiguration(config, dm);
    }

    public static int getTabletScalSize(int size, float scale) {
        if (isTabletScaleSize) {
            float scaleMultiple = 2.9f - screenScale;
            return (int)((float)size * scale * scaleMultiple);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static byte[] convertDrawableToByteArray(@NonNull Resources res, @RawRes int rid) {
        byte[] data = null;
        InputStream is = res.openRawResource(rid);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            data = baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public static Bitmap decodeBitmapFromRid(Resources resources, int rid, int inSampleSize) {
        if (rid == 0) {
            return null;
        }
        BitmapFactory.Options options = BaseGlobal.getBitmapOptions(inSampleSize);
        InputStream is = resources.openRawResource(rid);
        return BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
    }

    public static Bitmap decodeBitmapFromByteArray(byte[] byteArray, int inSampleSize) {
        if (byteArray == null) {
            return null;
        }
        BitmapFactory.Options options = BaseGlobal.getBitmapOptions(inSampleSize);
        return BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)options);
    }

    private static BitmapFactory.Options getBitmapOptions(int inSampleSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inSampleSize = inSampleSize;
        return options;
    }

    public static String convertBytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String convertBytesToString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            byte v = src[i];
            String hv = Integer.toString(v);
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String convertBytesToAscii(byte[] src) {
        String asciiStr = "";
        try {
            asciiStr = new String(src, "ISO8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return asciiStr;
    }

    public static byte[] convertHexToByteArray(String hexString) {
        char[] hex = hexString.toCharArray();
        int length = hex.length / 2;
        byte[] rawData = new byte[length];
        for (int i = 0; i < length; ++i) {
            int low;
            int high = Character.digit(hex[i * 2], 16);
            int value = high << 4 | (low = Character.digit(hex[i * 2 + 1], 16));
            if (value > 127) {
                value -= 256;
            }
            rawData[i] = (byte)value;
        }
        return rawData;
    }

    public static String convertDecimalToHex(int decimal, int digit) {
        StringBuilder hexStr = new StringBuilder(Integer.toHexString(decimal));
        while (hexStr.length() < digit) {
            hexStr.insert(0, "0");
        }
        return hexStr.toString().toUpperCase();
    }

    public static String convertHexToBinary(String hex, int bitCount) {
        StringBuilder binaryStr = new StringBuilder(new BigInteger(hex, 16).toString(2));
        while (binaryStr.length() < bitCount) {
            binaryStr.insert(0, "0");
        }
        return binaryStr.toString();
    }

    public static String convertBinaryToHex(String binary) {
        StringBuilder hexStr = new StringBuilder(new BigInteger(binary, 2).toString(16));
        while (hexStr.length() < 2) {
            hexStr.insert(0, "0");
        }
        return hexStr.toString().toUpperCase();
    }

    public static int convertBinaryToDecimal(String binary) {
        return Integer.parseInt(binary, 2);
    }

    public static String convertBecimalToBinary(int decimal, int bitCount) {
        StringBuilder binaryStr = new StringBuilder(Integer.toBinaryString(decimal));
        while (binaryStr.length() < bitCount) {
            binaryStr.insert(0, "0");
        }
        return binaryStr.toString();
    }

    static {
        toast = null;
    }
}

