/*
 * Decompiled with CFR 0.152.
 */
package com.ideabus.ideabuslibrary;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.DisplayMetrics;
import com.ideabus.ideabuslibrary.BaseGlobal;

public abstract class BaseActivity
extends FragmentActivity {
    private Dialog dialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        DisplayMetrics metrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        BaseGlobal.density = metrics.density;
        int width = metrics.widthPixels;
        int height = metrics.heightPixels;
        BaseGlobal.screenWidth = width;
        BaseGlobal.screenHeight = height;
        BaseGlobal.isTabletScaleSize = width > height ? (BaseGlobal.screenScale = (float)(height = BaseGlobal.screenWidth) / (float)(width = height)) <= 1.4f : (BaseGlobal.screenScale = (float)height / (float)width) >= 1.4f;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.cancelAlert();
    }

    protected abstract void initFragment();

    protected abstract void initView();

    protected abstract void initParam();

    protected abstract void initListener();

    public void showBaseAlert(int titleRid, int confirmRid, boolean cancelable, int messageRid, DialogInterface.OnClickListener onClick) {
        this.showBaseAlert(titleRid, confirmRid, cancelable, this.getString(messageRid), onClick);
    }

    public void showBaseAlert(int titleRid, int confirmRid, boolean cancelable, String messageStr, DialogInterface.OnClickListener onClick) {
        this.showBaseAlert(this.getString(titleRid), this.getString(confirmRid), cancelable, messageStr, onClick);
    }

    public void showBaseAlert(String titleStr, String confirmStr, boolean cancelable, String messageStr, DialogInterface.OnClickListener onClick) {
        if (this.isDestroyed()) {
            return;
        }
        this.cancelAlert();
        this.dialog = new AlertDialog.Builder((Context)this).setTitle((CharSequence)titleStr).setMessage((CharSequence)messageStr).setCancelable(cancelable).setNegativeButton((CharSequence)confirmStr, onClick).create();
        this.dialog.show();
    }

    public void cancelAlert() {
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    protected void goPage(Class cls, boolean isFinish) {
        Intent it = new Intent((Context)this, cls);
        this.startActivity(it);
        this.overridePendingTransition(0x10A0000, 0x10A0001);
        if (isFinish) {
            this.finish();
        }
    }
}

