package com.ideabus.ideabuslibrary.cloud;

import android.support.annotation.NonNull;

import com.ideabus.ideabuslibrary.BaseGlobal;

import org.apache.http.Consts;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;


public abstract class BaseHttpPost extends BaseHttpModule{

	private static final String TAG = BaseHttpPost.class.getSimpleName();

    @Override
    protected void apiGetSucceeded(String apiUrl, String result){

    }
    @Override
    protected void apiGetFailed(String apiUrl, int errorCode, String errorMessage){

    }

	/**
	 * 發送夾帶檔案的資料至Server
	 * @param url Post完整網址
	 * @param archivesUrl 檔案名稱
	 * @param key 要Post的檔案的Key
	 * @param data 要上傳的檔案
     * @param body 其他要Post的參數
     */
	protected void postArchives(String url, String archivesUrl,
                                String key, byte[] data, @NonNull ArrayList<NameValuePair> body){
		final String api = archivesUrl;
		final String postUrl = url + api;
		final String postKey = key;
		final byte[] rawData = data;
		final ArrayList<NameValuePair> textBody = body;

		new Thread() {
			public void run() {
				try{
					HttpClient client = new DefaultHttpClient();
					HttpPost httpPost = new HttpPost(postUrl);
					MultipartEntityBuilder builder = MultipartEntityBuilder.create();
					builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);//瀏覽器兼容模式

					ContentType encode = ContentType.create("application/json", Consts.UTF_8);

					if(rawData != null)
					    builder.addBinaryBody(postKey, rawData, ContentType.MULTIPART_FORM_DATA, "image");

					for(NameValuePair values : textBody){
						String name = values.getName();
						String value = values.getValue();
						if(name == null || value == null || name.length() == 0 || value.length() == 0)
							continue;
						builder.addTextBody(name, value, encode);
					}

					httpPost.setEntity(builder.build());

					HttpResponse response = client.execute(httpPost);
					final String result = EntityUtils.toString(response.getEntity());

//					entity.consumeContent();
//					client.getConnectionManager().shutdown();

					handler.post(new Runnable() {
						@Override
						public void run() {
							apiPostArchivesSucceeded(api, result);
						}
					});

				} catch (UnknownHostException e) {
					handler.post(new Runnable() {
						@Override
						public void run() {
							apiPostArchivesFailed(api, ERROR_CODE_NO_INTERNET, "No internet");
						}
					});
					e.printStackTrace();
				} catch (final Exception e) {
					handler.post(new Runnable() {
						@Override
						public void run() {
							apiPostArchivesFailed(api, ERROR_CODE_UNKNOWN_ERROR, e.toString());
						}
					});
					e.printStackTrace();
				}
			}
		}.start();
	}

	/**
	 * 發送資料至Server
	 * @param url Post完整網址
	 * @param apiUrl API Url
	 * @param params Post參數
	 */
	protected void postText(String url, String apiUrl, ArrayList<NameValuePair> params){
		final String api = apiUrl;
		final String postUrl = url + api;
		final ArrayList<NameValuePair> postParams = params;

		new Thread(){
			public void run(){
				HttpURLConnection urlConnection = null;
				OutputStream outputStream = null;
				ByteArrayOutputStream byteArrayOutputStream = null;
				try {
					byte[] data = getRequestData(postParams, "UTF-8").toString().getBytes();
					urlConnection = (HttpURLConnection) new URL(postUrl).openConnection();
					urlConnection.setRequestMethod("POST");
					urlConnection.setConnectTimeout(10000);
					urlConnection.setDoInput(true);
					urlConnection.setDoOutput(true);
					urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
					urlConnection.setRequestProperty("Content-Length", String.valueOf(data.length));

					outputStream = urlConnection.getOutputStream();
					outputStream.write(data);
					outputStream.flush();

					final int statusCode = urlConnection.getResponseCode();
                    BaseGlobal.printLog("d", TAG, "postText --- statusCode = " + statusCode);

					if(statusCode == HttpURLConnection.HTTP_OK) {
						InputStream inputStream = urlConnection.getInputStream();

						byteArrayOutputStream = new ByteArrayOutputStream();
						byte[] bytes = new byte[1024];
						int len;
						while((len = inputStream.read(bytes)) != -1) {
							byteArrayOutputStream.write(bytes, 0, len);
						}
						final String result = new String(byteArrayOutputStream.toByteArray());
						handler.post(new Runnable() {
							@Override
							public void run() {
								apiPostSucceeded(api, result);
							}
						});
					}else{
						handler.post(new Runnable() {
							@Override
							public void run() {
								apiPostFailed(api, ERROR_CODE_SERVER_ERROR, "status code:" + statusCode);
							}
						});
					}

				} catch (UnknownHostException e) {
					e.printStackTrace();
					handler.post(new Runnable() {
						@Override
						public void run() {
							apiPostFailed(api, ERROR_CODE_NO_INTERNET, "No internet");
						}
					});
				} catch (final Exception e) {
					e.printStackTrace();
					handler.post(new Runnable() {
						@Override
						public void run() {
							apiPostFailed(api, ERROR_CODE_UNKNOWN_ERROR, e.toString());
						}
					});
				} finally {
					if(urlConnection != null){
						urlConnection.disconnect();
					}
					if(outputStream != null){
						try {
							outputStream.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
					if(byteArrayOutputStream != null){
						try {
							byteArrayOutputStream.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
				}
			}
		}.start();
	}

}
