package com.ideabus.ideabuslibrary.cloud;

import com.ideabus.ideabuslibrary.BaseGlobal;

import org.apache.http.NameValuePair;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;

public abstract class BaseHttpGet extends BaseHttpModule {

	private static final String TAG = BaseHttpGet.class.getSimpleName();

    @Override
    protected void apiPostArchivesSucceeded(String apiUrl, String result){

    }
    @Override
    protected void apiPostArchivesFailed(String apiUrl, int errorCode, String errorMessage){

    }
    @Override
    protected void apiPostSucceeded(String apiUrl, String result){

    }
    @Override
    protected void apiPostFailed(String apiUrl, int errorCode, String errorMessage){

    }


	protected void httpGetMethod(String url, String apiUrl, ArrayList<NameValuePair> params){
		final String api = apiUrl;
		final String postUrl = url + api;
		final ArrayList<NameValuePair> headers = params;

		new Thread(){
			public void run(){
				HttpURLConnection urlConnection = null;
				ByteArrayOutputStream byteArrayOutputStream = null;
				try {
					urlConnection = (HttpURLConnection) new URL(postUrl).openConnection();
					urlConnection.setRequestMethod("GET");
					urlConnection.setConnectTimeout(10000);
					for(NameValuePair valuePair : headers){
						urlConnection.setRequestProperty(valuePair.getName(), valuePair.getValue());
					}

					final int statusCode = urlConnection.getResponseCode();
					BaseGlobal.printLog("d", TAG, "httpGetMethod --- statusCode = " + statusCode);

					if(statusCode == HttpURLConnection.HTTP_OK) {
						InputStream inputStream = urlConnection.getInputStream();

						byteArrayOutputStream = new ByteArrayOutputStream();
						byte[] bytes = new byte[1024];
						int len;
						while((len = inputStream.read(bytes)) != -1) {
							byteArrayOutputStream.write(bytes, 0, len);
						}
						final String result = new String(byteArrayOutputStream.toByteArray());
						handler.post(new Runnable() {
							@Override
							public void run() {
								apiGetSucceeded(api, result);
							}
						});
					}else{
						handler.post(new Runnable() {
							@Override
							public void run() {
								apiGetFailed(api, ERROR_CODE_SERVER_ERROR, "status code:" + statusCode);
							}
						});
					}


				} catch (UnknownHostException e) {
					e.printStackTrace();
					handler.post(new Runnable() {
						@Override
						public void run() {
                            apiGetFailed(api, ERROR_CODE_NO_INTERNET, "No internet");
						}
					});
				} catch (final Exception e) {
					e.printStackTrace();
					handler.post(new Runnable() {
						@Override
						public void run() {
                            apiGetFailed(api, ERROR_CODE_UNKNOWN_ERROR, e.toString());
						}
					});
				} finally {
					if(urlConnection != null){
						urlConnection.disconnect();
					}
					if(byteArrayOutputStream != null){
						try {
							byteArrayOutputStream.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
				}
			}
		}.start();
	}

}
