package com.ideabus.ideabuslibrary.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;

import com.ideabus.ideabuslibrary.BaseGlobal;

public class BluetoothLEHandler extends Handler {

	private static final String TAG = BluetoothLEHandler.class.getSimpleName();
	private BluetoothLEUtils bluetooth;
	private BluetoothAdapter mBluetoothAdapter;
	private boolean isRun = false;
	
	public BluetoothLEHandler(BluetoothLEUtils bt, BluetoothAdapter adapter){
		bluetooth = bt;
		mBluetoothAdapter = adapter;
	}
	
	@Override
	public void handleMessage(Message message) {
		super.handleMessage(message);
		
		switch (message.what) {
		case BluetoothLEUtils.SCAN_LOOP:
			if(!bluetooth.isScanning)
				return;
			bluetooth.startLEScan(message.arg1, true);
			if(BluetoothLEClass.mOnIMBluetoothLEListener != null)
				BluetoothLEClass.mOnIMBluetoothLEListener.connectionStatus(BluetoothLEUtils.SCAN_FINISH);
			break;
//		case BluetoothLEUtils.SCAN_STOP:	//停止掃描
		case BluetoothLEUtils.SCAN_FINISH:	//掃描完成
		
			bluetooth.isScanning = false;
			
        	if (mBluetoothAdapter != null)
        		mBluetoothAdapter.stopLeScan(bluetooth.setLeScanCallback());
        	
        	if(BluetoothLEClass.mOnIMBluetoothLEListener != null)
				BluetoothLEClass.mOnIMBluetoothLEListener.connectionStatus(message.what);
			
			break;
		case BluetoothLEUtils.CONNECTING:	//連線中
			BaseGlobal.printLog("d", TAG, "正在創建 第 " + message.arg1 + " 顆藍牙連線");
			bluetooth.mCurrentStatus = BluetoothLEUtils.CONNECTING;
			// 是否要直接連接到設備，設置了自動連接為false。
			bluetooth.addBluetoothGatt(((BluetoothDevice) message.obj).connectGatt(
					bluetooth.getContext(), false, bluetooth.setLeGattCallback()));
//        	Log.d(TAG, "refresh BluetoothGatt = " + bluetooth.refreshDeviceCache(bluetooth.getBluetoothGatt(message.arg1)));
			break;
		case BluetoothLEUtils.CONNECT_TIMEOUT:	//連線Timeout
			if(bluetooth.mCurrentStatus != BluetoothLEUtils.CONNECTED){	//如果20秒後未連線
				BaseGlobal.printLog("d", TAG, "連線超時");
				bluetooth.disconnect(BluetoothLEUtils.DISCONNECTED);
			}
			break;
//		case BluetoothLEUtils.COMMAND_TIMEOUT:	//Command Timeout
//			Log.e(TAG, "Command超時");
//			bluetooth.disconnect(BluetoothLEUtils.DISCONNECTED);
//			break;
//		case BluetoothLEUtils.DISCONNECTED:	//DISCONNECTED
//		case BluetoothLEUtils.RECEIVED_ERROR:	//RECEIVED ERROR
//			int i = message.arg1;
//			try{
//				if (bluetooth.getBluetoothGatt(i) != null) {
//					bluetooth.getBluetoothGatt(i).close();
//					
//					if (CustomVariable.deBugMode)
//						Log.e(TAG, "close : " + i);
//                }
//			}catch(Exception e){ }
//			
//			bluetooth.removeBluetoothGatt();
//			
//			break;
		case BluetoothLEUtils.SCAN_RESULT:	//掃描到BLE
			if(BluetoothLEClass.mOnIMBluetoothLEListener != null){
				Bundle bd = message.getData();
				BluetoothLEClass.mOnIMBluetoothLEListener.scanResult(
						bd.getString("address"), bd.getString("name"), bd.getInt("rssi"), bd.getByteArray("scanRecord"));
			}
			break;
		case BluetoothLEUtils.CALLBACK_STATE:	//藍芽狀態
			if(BluetoothLEClass.mOnIMBluetoothLEListener != null)
				BluetoothLEClass.mOnIMBluetoothLEListener.connectionStatus(bluetooth.mCurrentStatus);
			
			if(bluetooth.mCurrentStatus == BluetoothLEUtils.CONNECTED && !isRun){
				isRun = true;
				bluetooth.onWriteThreadStart(this);
			}else {
				isRun = false;
			}
			break;
		case BluetoothLEUtils.CALLBACK_RESULT:
			if(BluetoothLEClass.mOnIMBluetoothLEListener != null)
				BluetoothLEClass.mOnIMBluetoothLEListener.dataResult((String) message.obj);
			break;
		}
	}
	
}
