/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.topic.service;

import com.icthh.xm.commons.topic.domain.DynamicConsumer;
import com.icthh.xm.commons.topic.domain.TopicConfig;
import com.icthh.xm.commons.topic.message.MessageHandler;
import com.icthh.xm.commons.topic.service.AbstractDynamicConsumerConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class TopicDynamicConsumerConfiguration
extends AbstractDynamicConsumerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TopicDynamicConsumerConfiguration.class);
    private final MessageHandler messageHandler;
    private Map<String, List<DynamicConsumer>> tenantTopicConsumers = new ConcurrentHashMap<String, List<DynamicConsumer>>();

    public TopicDynamicConsumerConfiguration(ApplicationEventPublisher applicationEventPublisher, MessageHandler messageHandler) {
        super(applicationEventPublisher);
        this.messageHandler = messageHandler;
    }

    @Override
    public List<DynamicConsumer> getDynamicConsumers(String tenantKey) {
        if (this.tenantTopicConsumers.containsKey(tenantKey)) {
            return this.tenantTopicConsumers.get(tenantKey);
        }
        return List.of();
    }

    public Map<String, List<DynamicConsumer>> getTenantTopicConsumers() {
        return Collections.unmodifiableMap(this.tenantTopicConsumers);
    }

    protected void refreshConfig(List<TopicConfig> forUpdate, String tenantKey) {
        List dynamicConsumers = forUpdate.stream().map(this::createDynamicConsumer).collect(Collectors.toList());
        this.tenantTopicConsumers.put(tenantKey, dynamicConsumers);
    }

    protected void remove(String tenantKey) {
        this.tenantTopicConsumers.remove(tenantKey);
    }

    private DynamicConsumer createDynamicConsumer(TopicConfig topicConfig) {
        DynamicConsumer dynamicConsumer = new DynamicConsumer();
        dynamicConsumer.setConfig(topicConfig);
        dynamicConsumer.setMessageHandler(this.messageHandler);
        return dynamicConsumer;
    }
}

