/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.topic.service;

import com.icthh.xm.commons.logging.LoggingAspectConfig;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Service;

@Service
public class KafkaTemplateService {
    private final KafkaTemplate<String, String> kafkaTemplate;

    @LoggingAspectConfig(inputExcludeParams={"data"}, resultDetails=false)
    public CompletableFuture<SendResult<String, String>> send(String topic, String data) {
        return this.kafkaTemplate.send(topic, (Object)data);
    }

    @LoggingAspectConfig(inputExcludeParams={"data"}, resultDetails=false)
    public CompletableFuture<SendResult<String, String>> send(String topic, Integer partition, String key, String data) {
        return this.kafkaTemplate.send(topic, partition, (Object)key, (Object)data);
    }

    @LoggingAspectConfig(inputExcludeParams={"data"}, resultDetails=false)
    public CompletableFuture<SendResult<String, String>> send(String topic, String data, Map<String, Object> headers) {
        return this.send(topic, null, null, data, headers);
    }

    public CompletableFuture<SendResult<String, String>> send(String topic, Integer partition, String key, String data, Map<String, Object> headers) {
        MessageBuilder builder = MessageBuilder.withPayload((Object)data).setHeader("kafka_topic", (Object)topic).setHeader("kafka_messageKey", (Object)key);
        if (partition != null) {
            builder.setHeader("kafka_partitionId", (Object)partition);
        }
        if (headers != null) {
            builder.copyHeaders(headers);
        }
        Message message = builder.build();
        return this.kafkaTemplate.send(message);
    }

    public KafkaTemplateService(KafkaTemplate<String, String> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }
}

