/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.topic.config;

import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.AcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.adapter.AbstractRetryingMessageListenerAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.lang.Nullable;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryState;
import org.springframework.retry.support.DefaultRetryState;
import org.springframework.retry.support.RetryTemplate;

public class RetryingMessageListenerAdapter<K, V>
extends AbstractRetryingMessageListenerAdapter<K, V, MessageListener<K, V>>
implements AcknowledgingConsumerAwareMessageListener<K, V> {
    public static final String CONTEXT_ACKNOWLEDGMENT = "acknowledgment";
    public static final String CONTEXT_CONSUMER = "consumer";
    public static final String CONTEXT_RECORD = "record";
    private boolean stateful;

    public RetryingMessageListenerAdapter(MessageListener<K, V> delegate, RetryTemplate retryTemplate, RecoveryCallback<?> recoveryCallback, boolean stateful) {
        super(delegate, retryTemplate, recoveryCallback);
        this.stateful = stateful;
    }

    public void onMessage(ConsumerRecord<K, V> record, @Nullable Acknowledgment acknowledgment, Consumer<?, ?> consumer) {
        DefaultRetryState retryState = null;
        if (this.stateful) {
            retryState = new DefaultRetryState((Object)(record.topic() + "-" + record.partition() + "-" + record.offset()));
        }
        this.getRetryTemplate().execute(context -> {
            context.setAttribute(CONTEXT_RECORD, (Object)record);
            switch (this.delegateType) {
                case ACKNOWLEDGING_CONSUMER_AWARE: {
                    context.setAttribute(CONTEXT_ACKNOWLEDGMENT, (Object)acknowledgment);
                    context.setAttribute(CONTEXT_CONSUMER, (Object)consumer);
                    ((MessageListener)this.delegate).onMessage((Object)record, acknowledgment, consumer);
                    break;
                }
                case ACKNOWLEDGING: {
                    context.setAttribute(CONTEXT_ACKNOWLEDGMENT, (Object)acknowledgment);
                    ((MessageListener)this.delegate).onMessage((Object)record, acknowledgment);
                    break;
                }
                case CONSUMER_AWARE: {
                    context.setAttribute(CONTEXT_CONSUMER, (Object)consumer);
                    ((MessageListener)this.delegate).onMessage((Object)record, consumer);
                    break;
                }
                case SIMPLE: {
                    ((MessageListener)this.delegate).onMessage((Object)record);
                }
            }
            return null;
        }, this.getRecoveryCallback(), (RetryState)retryState);
    }

    public void onMessage(ConsumerRecord<K, V> data) {
        this.onMessage(data, (Acknowledgment)null, (Consumer<?, ?>)null);
    }

    public void onMessage(ConsumerRecord<K, V> data, Acknowledgment acknowledgment) {
        this.onMessage(data, acknowledgment, (Consumer<?, ?>)null);
    }

    public void onMessage(ConsumerRecord<K, V> data, Consumer<?, ?> consumer) {
        this.onMessage(data, (Acknowledgment)null, consumer);
    }
}

