/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.topic.message;

import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import com.icthh.xm.commons.topic.domain.TopicConfig;
import com.icthh.xm.commons.topic.message.MessageHandler;
import com.icthh.xm.commons.topic.message.MessageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"lepManager"})
public class DefaultMessageHandler
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultMessageHandler.class);
    private final MessageService messageListenerService;
    private final TenantContextHolder tenantContextHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(String message, String tenant, TopicConfig topicConfig) {
        try {
            this.init(tenant);
            this.messageListenerService.onMessage(message, topicConfig);
        }
        finally {
            this.destroy();
        }
    }

    private void init(String tenantKey) {
        TenantContextUtils.setTenant((TenantContextHolder)this.tenantContextHolder, (String)tenantKey);
    }

    private void destroy() {
        this.tenantContextHolder.getPrivilegedContext().destroyCurrentContext();
    }

    public DefaultMessageHandler(MessageService messageListenerService, TenantContextHolder tenantContextHolder) {
        this.messageListenerService = messageListenerService;
        this.tenantContextHolder = tenantContextHolder;
    }
}

