/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.topic.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.topic.domain.DynamicConsumer;
import com.icthh.xm.commons.topic.domain.TopicConfig;
import com.icthh.xm.commons.topic.domain.TopicConsumersSpec;
import com.icthh.xm.commons.topic.message.MessageHandler;
import com.icthh.xm.commons.topic.service.DynamicConsumerConfiguration;
import com.icthh.xm.commons.topic.service.DynamicConsumerConfigurationService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

@Component
public class TopicConfigurationService
implements RefreshableConfiguration,
DynamicConsumerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TopicConfigurationService.class);
    private static final String TENANT_NAME = "tenant";
    private AntPathMatcher matcher = new AntPathMatcher();
    private ObjectMapper ymlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final String configPath;
    private final MessageHandler messageHandler;
    private final DynamicConsumerConfigurationService dynamicConsumerConfigurationService;
    private Map<String, List<DynamicConsumer>> tenantTopicConsumers = new ConcurrentHashMap<String, List<DynamicConsumer>>();

    public TopicConfigurationService(@Value(value="${spring.application.name}") String appName, @Lazy DynamicConsumerConfigurationService dynamicConsumerConfigurationService, MessageHandler messageHandler) {
        this.configPath = "/config/tenants/{tenant}/" + appName + "/topic-consumers.yml";
        this.dynamicConsumerConfigurationService = dynamicConsumerConfigurationService;
        this.messageHandler = messageHandler;
    }

    public void onRefresh(String updatedKey, String config) {
        this.refreshConfig(updatedKey, config);
    }

    public boolean isListeningConfiguration(String updatedKey) {
        return this.matcher.match(this.configPath, updatedKey);
    }

    @Override
    public List<DynamicConsumer> getDynamicConsumers(String tenantKey) {
        if (this.tenantTopicConsumers.containsKey(tenantKey)) {
            return this.tenantTopicConsumers.get(tenantKey);
        }
        return List.of();
    }

    public Map<String, List<DynamicConsumer>> getTenantTopicConsumers() {
        return Collections.unmodifiableMap(this.tenantTopicConsumers);
    }

    private void refreshConfig(String updatedKey, String config) {
        String tenantKey = this.extractTenant(updatedKey);
        if (StringUtils.isEmpty((CharSequence)config)) {
            this.tenantTopicConsumers.remove(tenantKey);
        } else {
            this.readSpec(updatedKey, config).ifPresentOrElse(spec -> {
                List<TopicConfig> forUpdate = spec.getTopics();
                List dynamicConsumers = forUpdate.stream().map(this::createDynamicConsumer).collect(Collectors.toList());
                this.tenantTopicConsumers.put(tenantKey, dynamicConsumers);
            }, () -> log.warn("Skip processing of configuration: [{}]. Specification is null", (Object)updatedKey));
        }
        this.dynamicConsumerConfigurationService.refreshDynamicConsumers(tenantKey);
    }

    private String extractTenant(String updatedKey) {
        return (String)this.matcher.extractUriTemplateVariables(this.configPath, updatedKey).get(TENANT_NAME);
    }

    private Optional<TopicConsumersSpec> readSpec(String updatedKey, String config) {
        try {
            return Optional.of((TopicConsumersSpec)this.ymlMapper.readValue(config, TopicConsumersSpec.class));
        }
        catch (Exception e) {
            log.error("Error read topic specification from path: {}", (Object)updatedKey, (Object)e);
            return Optional.empty();
        }
    }

    private DynamicConsumer createDynamicConsumer(TopicConfig topicConfig) {
        DynamicConsumer dynamicConsumer = new DynamicConsumer();
        dynamicConsumer.setConfig(topicConfig);
        dynamicConsumer.setMessageHandler(this.messageHandler);
        return dynamicConsumer;
    }
}

