/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.topic.config;

import com.icthh.xm.commons.topic.config.ConsumerRecoveryCallback;
import com.icthh.xm.commons.topic.config.MessageListener;
import com.icthh.xm.commons.topic.config.MessageRetryTemplate;
import com.icthh.xm.commons.topic.domain.TopicConfig;
import com.icthh.xm.commons.topic.message.MessageHandler;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.SeekToCurrentErrorHandler;
import org.springframework.kafka.listener.adapter.RetryingMessageListenerAdapter;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;

public class MessageListenerContainerBuilder {
    private final KafkaProperties kafkaProperties;
    private final KafkaTemplate<String, String> kafkaTemplate;

    public AbstractMessageListenerContainer build(String tenantKey, TopicConfig topicConfig, MessageHandler messageHandler) {
        Map<String, Object> consumerConfig = this.buildConsumerConfig(topicConfig);
        DefaultKafkaConsumerFactory kafkaConsumerFactory = new DefaultKafkaConsumerFactory(consumerConfig, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
        ContainerProperties containerProperties = new ContainerProperties(new String[]{topicConfig.getTopicName()});
        containerProperties.setAckMode(ContainerProperties.AckMode.MANUAL_IMMEDIATE);
        containerProperties.setMessageListener((Object)new RetryingMessageListenerAdapter((org.springframework.kafka.listener.MessageListener)new MessageListener(messageHandler, tenantKey, topicConfig), (RetryTemplate)new MessageRetryTemplate(topicConfig), (RecoveryCallback)new ConsumerRecoveryCallback(tenantKey, topicConfig, this.kafkaTemplate), true));
        ConcurrentMessageListenerContainer container = new ConcurrentMessageListenerContainer((ConsumerFactory)kafkaConsumerFactory, containerProperties);
        container.setErrorHandler((ErrorHandler)new SeekToCurrentErrorHandler(topicConfig.getRetriesCount() + 1));
        return container;
    }

    private Map<String, Object> buildConsumerConfig(TopicConfig topicConfig) {
        Map props = this.kafkaProperties.buildConsumerProperties();
        String groupIdFromConf = topicConfig.getGroupId();
        String groupId = StringUtils.isEmpty((CharSequence)groupIdFromConf) ? UUID.randomUUID().toString() : groupIdFromConf;
        props.put("group.id", groupId);
        props.put("enable.auto.commit", false);
        if (topicConfig.getMaxPollInterval() != null) {
            props.put("max.poll.interval.ms", topicConfig.getMaxPollInterval());
        }
        return Collections.unmodifiableMap(props);
    }

    public MessageListenerContainerBuilder(KafkaProperties kafkaProperties, KafkaTemplate<String, String> kafkaTemplate) {
        this.kafkaProperties = kafkaProperties;
        this.kafkaTemplate = kafkaTemplate;
    }
}

